// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __BoringAtom_h__
#include "BoringAtom.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

namespace {
  class InspectAtom
    : public TypedFactory <ActionConfiguration, Action>
  {
  public:
    InspectAtom ()
      : TypedFactory <ActionConfiguration, Action> ("InspectAtom")
    {}
    SP<ActionConfiguration> typedDefaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Action> makeIt (ActionConfiguration *conf) const {
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      SP<Action> result = NEW (Action ());
      int index;
      Vec3 intersectionPoint;
      if (top->findUnderMouse (index, intersectionPoint)) {
	SP<const PhysicsObject> po = sg->object (index);
	const Vec3 center = po->boundingSphereCenter (sg->objectState (index));
	SP<const BoringAtom> ba = dynamic_cast <const BoringAtom *> (&*po);
	String msgStart =
	  (String ("The cursor is pointing at object ")
	   + index + " which is a ");
	String linkString = String ("at position ") + center;
	{
	  int count;
	  const int *links;
	  sg->getLinkManager()->getLinks (index, count, links);
	  if (0 == count) {
	    linkString += "\nwith no links";
	  } else {
	    linkString += "\nwith links to";
	    for (int i = 0; i < count; i++) {
	      linkString += " " + String (links[i]);
	    }
	  }
	}
	// If exactly one object is selected, report the distance from that
	// object.
	{
	  Dynavec <int> selection;
	  SelectionManager::getSelection (selection);
	  if (1 == selection.size ()) {
	    const int s = selection [0];
	    Vec3 selectionCenter =
	      sg->object (s)->boundingSphereCenter (sg->objectState (s));
	    linkString +=
	      String ("\nThe distance from selected object ")+
	      s + " is "+ (center - selectionCenter).length ();
	  }
	}
	if (ba) {
	  Float *state = sg->objectState (index);
	  result->setMessage
	    (msgStart
	     + ba->getFactory()->unParse()
	     + "\nwith velocity "+ BoringAtom::velocity (state)
	     + "\n" + linkString);
	} else {
	  result->setMessage (msgStart + po->classId () + "\n" + linkString);
	}
      } else {
	Dynavec <int> selection;
	SelectionManager::getSelection (selection);
	if (0 == selection.size ()) {
	  result->setMessage ("The cursor is not pointing at anything, "
			      "and nothing is selected");
	} else {
	  result->setMessage (String (selection.size()) + " objects selected");
	}
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("KeyboardMouseAction", NEW (InspectAtom ())),
   true);
}
