// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __InferBondsConfiguration_h__
#include "InferBondsConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __FloatUtil_h__
#include "FloatUtil.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

namespace {
  class InferBonds
    : public TypedFactory <InferBondsConfiguration, Action>
  {
  public:
    InferBonds ()
      : TypedFactory <InferBondsConfiguration, Action> ("InferBonds")
    {}
    SP<InferBondsConfiguration> typedDefaultConfiguration () const {
      return NEW (InferBondsConfiguration ());
    }
    SP<Action> makeIt (InferBondsConfiguration *conf) const {
      Float maxLengthSquared = FloatUtil::sqr (conf->getMaxLength ());
      Dynavec <int> selection;
      SelectionManager::getSelection (selection);
      SP<Action> result = NEW (Action ());
      if (!selection.size ()) {
	result->setProblem ("Select something first");
      } else {
	SP<TopLevel> top = conf->getTopLevel ();
	SP<SceneGraph> sg = top->getSceneGraph ();
	SP<LinkManager> lm = sg->getLinkManager ();
	bool didWork = false;
	for (int i = 0; i < selection.size(); i++) {
	  const int si = selection [i];
	  const Vec3 iCenter = sg->boundingSphereCenter (si);
	  for (int j = i+1; j < selection.size(); j++) {
	    const int sj = selection [j];
	    const Vec3 jCenter = sg->boundingSphereCenter (sj);
	    if ((iCenter - jCenter).lengthSquared () <= maxLengthSquared) {
	      didWork = true;
	      lm->addNewLink (sj, si);
	      lm->addNewLink (si, sj);
	    }
	  }
	}
	if (!didWork) {
	  result->setProblem ("No work to do");
	}
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (InferBonds ())),
   false);
}
