// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __EdgeHexConfiguration_h__
#define __EdgeHexConfiguration_h__

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class RecursiveSlotValue;
class EdgeHexConfiguration
  : public ActionConfiguration
{
public:
  EdgeHexConfiguration ();
  // Size of the new faces.  6 gives you hexagons, 5 pentagons, etc.
  int getNewFaceSize () const;
  void setNewFaceSize (const int size);
  // How big a face to recognize in the old figure.  8 is a good value, if you
  // want to be able to start with an octagon and build things around the
  // perimeter.  Unfortunately you can't build a dodecahedron if the value is
  // 8, since the last link that is added to close it up is dividing an octagon
  // in 2.  I generally use 7 if I'm adding pentagons and 8 otherwise.
  int getOldFaceSize () const;
  void setOldFaceSize (const int size);
  // How to make the new atoms.
  SP<RecursiveSlotValue> getAtomFactory ();
  SP<const RecursiveSlotValue> getAtomFactory () const;
  // If this is true, then we will add faces to all edges that have a selected
  // point.  If it's false, then we require both ends of the edge to be
  // selected.
  bool getSelectPoints () const;
  void setSelectPoints (bool points);
  void setAtomFactory (RecursiveSlotValue *rsv);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};
#endif
