// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __EdgeHexConfiguration_h__
#include "EdgeHexConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __PositiveIntSlotValue_h__
#include "PositiveIntSlotValue.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __BoolSlotValue_h__
#include "BoolSlotValue.h"
#endif

namespace {
  String faceSizeName () {
    return "Number of atoms in the new faces";
  }
  String oldFaceSizeName () {
    return "Number of atoms for recognizing old faces";
  }
  String atomFactoryName () {
    return "Factory for new atoms";
  }
  String selectPointsName () {
    return "true to select points or false to select edges";
  }
}

EdgeHexConfiguration::EdgeHexConfiguration () {
  initializeSlot (faceSizeName (), NEW (PositiveIntSlotValue (6)));
  initializeSlot (oldFaceSizeName (), NEW (PositiveIntSlotValue (8)));
  initializeSlot (atomFactoryName (), NEW (RecursiveSlotValue ("Atom",
							       "DesignAtom")));
  initializeSlot (selectPointsName (), NEW (BoolSlotValue (true)));
}

int EdgeHexConfiguration::getNewFaceSize () const {
  return PositiveIntSlotValue::getSlot (this, faceSizeName ());
}

void EdgeHexConfiguration::setNewFaceSize (const int size) {
  PositiveIntSlotValue::setSlot (this, faceSizeName (), size);
}

int EdgeHexConfiguration::getOldFaceSize () const {
  return PositiveIntSlotValue::getSlot (this, oldFaceSizeName ());
}

void EdgeHexConfiguration::setOldFaceSize (const int size) {
  PositiveIntSlotValue::setSlot (this, oldFaceSizeName(), size);
}

SP<RecursiveSlotValue> EdgeHexConfiguration::getAtomFactory () {
  return RecursiveSlotValue::getSlotValue (this, atomFactoryName ());
}

SP<const RecursiveSlotValue> EdgeHexConfiguration::getAtomFactory () const {
  return RecursiveSlotValue::getSlotValue (this, atomFactoryName ());
}

void EdgeHexConfiguration::setAtomFactory (RecursiveSlotValue *rsv) {
  RecursiveSlotValue::setSlotValue (this, atomFactoryName(), rsv);
}

bool EdgeHexConfiguration::getSelectPoints () const {
  return BoolSlotValue::getSlot (this, selectPointsName ());
}

void EdgeHexConfiguration::setSelectPoints (bool points) {
  BoolSlotValue::setSlot (this, selectPointsName(), points);
}


SP<Configuration> EdgeHexConfiguration::copy () const {
  return NEW (EdgeHexConfiguration (*this));
}

bool EdgeHexConfiguration::hasTheSameTypeAs (const Configuration *c) const {
  return 0 != dynamic_cast <const EdgeHexConfiguration *> (c);
}
