// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

#ifndef __TextConfigurationEditor_h__
#include "TextConfigurationEditor.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __BoringAtom_h__
#include "BoringAtom.h"
#endif

#ifndef __KeyboardMouseEvent_h__
#include "KeyboardMouseEvent.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __CreateAtomConfiguration_h__
#include "CreateAtomConfiguration.h"
#endif

namespace {
  class CreateAtom
    : public TypedFactory <CreateAtomConfiguration, Action>
  {
  public:
    CreateAtom ()
      : TypedFactory <CreateAtomConfiguration, Action> ("CreateAtom")
    {}
    SP<CreateAtomConfiguration> typedDefaultConfiguration () const {
      return NEW (CreateAtomConfiguration ());
    }
    SP<Action> makeIt (CreateAtomConfiguration *conf) const {
      SP<RecursiveSlotValue> rsv = conf->getAtomSlot ();
      SP<BoringAtom> atom = dynamic_cast <BoringAtom *> (&*rsv->makeIt ());
      assert (atom);
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      SP<Canvas> canvas = top->getCanvas ();
      // We just use the Z coordinate of screenWhere.
      Vec3 screenWhere =
	canvas->transformWorldToRHScreen (sg->centerOfSomething ());
      SP<const KeyboardMouseEvent> e =
	dynamic_cast <const KeyboardMouseEvent *> (&*top->getEvent ());
      screenWhere [0] = e->getX ();
      screenWhere [1] = e->getY ();
      Vec3 worldWhere = canvas->transformRHScreenToWorld (screenWhere);
      Dynavec <Float> state;
      atom->plausibleState (state);
      BoringAtom::setCenter (&*state, worldWhere);
      const int index = sg->addObject (&*atom, state);
      SP<Action> result = NEW (Action ());
      if (-1 == index) {
	result->setProblem ("Failed to insert the new atom.");
      } else {
	Dynavec <int> selection;
	selection.push (index);
	SelectionManager::setSelection (sg, selection);
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("KeyboardMouseAction", NEW (CreateAtom ())),
   true);
}
