// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __BrennerAtom_h__
#include "BrennerAtom.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __BrennerAtomConfiguration_h__
#include "BrennerAtomConfiguration.h"
#endif

#ifndef __AtomInfo_h__
#include "AtomInfo.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __AtomCache_h__
#include "AtomCache.h"
#endif

typedef BrennerAtom::MotionFlag MotionFlag;

BrennerAtom::BrennerAtom (BrennerAtomConfiguration *conf, const Factory *f)
  : BoringAtom (conf, f),
    m_flag (conf->getMotionFlag ())
{}

MotionFlag BrennerAtom::getMotionFlag () const {
  return m_flag;
}

const char *const BrennerAtom::staticClassId = "BrennerAtom";

const char *BrennerAtom::classId () const {
  return staticClassId;
}

bool BrennerAtom::isInstanceOf (const char *classId) const {
  return classId == staticClassId || BoringAtom::isInstanceOf (classId);
}

class BrennerAtom::BrennerAtomFactory
  : public TypedFactory <BrennerAtomConfiguration, BrennerAtom>
{
  static SP<AtomCache <BrennerAtom> > s_cache;
  static void deallocate () {
    if (s_cache) {
      s_cache = 0;
    }
  }
  static const bool s_useless;
public:
  BrennerAtomFactory ()
    : TypedFactory <BrennerAtomConfiguration, BrennerAtom> ("BrennerAtom")
  {}
  SP<BrennerAtomConfiguration> typedDefaultConfiguration () const {
    return NEW (BrennerAtomConfiguration ());
  }
  SP<BrennerAtom> makeIt (BrennerAtomConfiguration *bac) const {
    SP<BrennerAtom> &ba = s_cache->cacheref (bac);
    if (!ba) {
      ba = NEW (BrennerAtom (bac, this));
    }
    return ba;
  }
};

SP<AtomCache<BrennerAtom> > BrennerAtom::BrennerAtomFactory::s_cache =
NEW (AtomCache <BrennerAtom> ());

const bool BrennerAtom::BrennerAtomFactory::s_useless =
(FactoryTable::store ("Atom", NEW (BrennerAtomFactory())),
 MemoryUtil::registerDeallocator (deallocate),
 true);
