// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __BoringAtom_h__
#define __BoringAtom_h__

#ifndef __DDPO_h__
#include "DDPO.h"
#endif

class String;
class AtomConfiguration;
class RecursiveSlotValue;
class Factory;
class BoringAtom
  : public DDPO
{
  struct BoringAtomData;
  BoringAtomData *m_data;
  class BoringAtomFactory;
  friend class BoringAtomFactory;
protected:
  // The constructor of BoringAtom takes a factory so we can implement the
  // getFactory method.  See the comment for that method below.
  BoringAtom (AtomConfiguration *b, const Factory *f);
public:
  ~BoringAtom ();
  // If you want the symbol name, get the symbol number and then use
  // AtomInfo::toSymbol.
  int getSymbolNumber () const;
  // How this atom was made.  If you want to make a similar atom, call
  // getFactory, make a copy, edit the copy, and call makeIt on the copy.
  SP<const RecursiveSlotValue> getFactory () const;
  static const char *const staticClassId;
  const char *classId () const;
  bool isInstanceOf (const char *classId) const;
  // Will return 6: 3 for state, then 3 for velocity.
  int stateSize () const;
  void plausibleState (Dynavec <Float> &result) const;
  static Vec3 velocity (const Float *state);
  static void setVelocity (Float *state, const Vec3 &v);
  static Vec3 center (const Float *state);
  static void setCenter (Float *state, const Vec3 &v);
  // We have to implement a bunch of boring PhysicsObject methods to make it
  // possible to instantiate a BoringAtom. These atoms are boring, so they
  // don't do interesting physics. 
  bool physicsIntersect (const Float *state,
			 const BoundingBox &box) const;
  Vec3 boundingSphereCenter (const Float *state) const;
  Float physicsBoundingSphereRadius () const;
  bool isPhysicsBounded () const;
  void translate (Float *state, const Vec3 &v) const;
  void rotate (Float *state, const Quaternion &q) const;
  bool exempt () const;
};
#endif
