#if 0
// We can't really draw sticks yet, all this gives you is small balls.
// Therefore this is not a useful menu option. 

// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __OneObjectDrawerConfiguration_h__
#include "OneObjectDrawerConfiguration.h"
#endif

#ifndef __BallConfiguration_h__
#include "BallConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __AtomConfiguration_h__
#include "AtomConfiguration.h"
#endif

#ifndef __AtomInfo_h__
#include "AtomInfo.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

#ifndef __TheObjectDrawerFactory_h__
#include "TheObjectDrawerFactory.h"
#endif

namespace {
  class BallAndStickDrawer
    : public TypedFactory<OneObjectDrawerConfiguration,Configurable>
  {
    String m_prefix;
  public:
    // Pass the window system prefix, such as "X", as the prefix argument
    // because this class isn't really window-system specific. 
    BallAndStickDrawer (const String &prefix)
      : TypedFactory<OneObjectDrawerConfiguration,Configurable> (prefix + "BallAndStickDrawer"),
	m_prefix (prefix)
    {}
    SP<OneObjectDrawerConfiguration> typedDefaultConfiguration () const {
      return NEW (OneObjectDrawerConfiguration ());
    }
    SP<Configurable> makeIt (OneObjectDrawerConfiguration *c) const {
      SP<Factory> ballDrawer = FactoryTable::load ("ObjectDrawer",
						    m_prefix + "BallDrawer");
      assert (ballDrawer);
      SP<OneObjectDrawerConfiguration> oodc =
	dynamic_cast <OneObjectDrawerConfiguration *>
	(&*ballDrawer->defaultConfiguration ());
      assert (oodc);
      SP<BallConfiguration> ballConf = NEW (BallConfiguration ());
      SP<AtomConfiguration> ac =
	dynamic_cast <AtomConfiguration *>
	(&*c->getPhysicsObjectConfiguration ());
      assert (ac);
      const int num = ac->getSymbolNumber ();
      // FIXME No sticks yet!
      // FIXME Bogus radius!
      // Take the right radius from the public domain version of rasmol.
      ballConf->setVisibleRadius (AtomInfo::VDWRadius (num)/2);
      ballConf->setMaterial (AtomInfo::CPKColor (num));
      oodc->setPhysicsObjectConfiguration (&*ballConf);
      return ballDrawer->makeIt (&*oodc);
    }
  };
  static const bool useless =
  (AtomConfiguration::registerDrawer ("BallAndStick", "Ball and Stick"),
   TheObjectDrawerFactory::registerObjectDrawer ("BallAndStick"),
   // Repeat the next line for each window system, substituting the window
   // system prefix for "X".  Hmm, maybe we need a static list of all window
   // systems somewhere and a loop here?  Not worth worrying about until we
   // have multiple viable window systems.
   FactoryTable::store ("ObjectDrawer", NEW (BallAndStickDrawer ("X"))),
   true);
}
#endif
