// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AtomInfo_h__
#define __AtomInfo_h__

#ifndef __Float_h__
#include "Float.h"
#endif

class Color;
class String;
class AtomInfo {
public:
  // Returns -1 if can't find it.  The implementation does linear search, so
  // the caller probably wants a hash table standing in front of this to cache
  // it.  (The hash table is not already built in because all actual callers
  // happen to want to have the hash table in front anyway for other reasons.)
  //
  // FIXME The hash table isn't always there, so we need one here.
  //
  // This theoretically is a performance bug in PDBSceneLoader, although it
  // still seems to go pretty fast compared to rasmol .
  static int symbolToNumber (const String &symbol);
  // Same story about performance here.
  static int nameToNumber (const String &symbol);
  // One more than the greatest symbol number.
  static const int maxNumber;
  // FIXME Faster to return a string by passing in a writable reference
  // This way requires memory allocation, which is relatively slow.
  static String toSymbol (int number);
  static String toName (int number);
  // Van-der-waals radius.  Result is in Angstroms.
  static Float VDWRadius (int number);
  static Color CPKColor (int number);
};

#endif
