// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AtomFactory_h__
#define __AtomFactory_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

class PhysicsObject;
class String;

class AtomFactory
  : public Configurable
{
public:
  // Given the atomic symbol for an atom, return an appropriate
  // PhysicsObject.  If given the same symbol twice, it should be fast
  // the second time and it should return the same PhysicsObject.
  // Recognition of symbol names is case insensitive.
  // If the symbol could not be found, return a null pointer.
  virtual SP<PhysicsObject> makeAtom (const String &symbol) = 0;
  // Likewise, except take the atomic number.
  virtual SP<PhysicsObject> makeAtom (const int atomicNumber) = 0;
};
#endif
