// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AtomConfiguration_h__
#define __AtomConfiguration_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __DDPOConfiguration_h__
#include "DDPOConfiguration.h"
#endif

class String;
class Configuration;
class MenuSlotValueChoices;
class AtomConfiguration
  : public DDPOConfiguration
{
public:
  // FIXME Hide BoringBallConfiguration fields from user configuration editing
  //
  // Here's why: the right default radius and color depend on which atom we're
  // creating.  The present configuration editor doesn't support that kind of
  // defaulting, so the next best thing to do is to make the radius and color
  // be unsettable, and make them depend on which atom we're creating.  They
  // should be invisible from the configuration editor too, since before you've
  // entered an atomic symbol there isn't any good value to have for the radius
  // and color.  But what we really have now is visible slots where the value
  // you put in them is going to be ignored.
  AtomConfiguration ();
  // Atomic number.
  // FIXME Need to guard against users entering out-of-bounds atomic numbers.
  // FIXME Need to let user enter atomic symbols.
  void setSymbolNumber (int num);
  int getSymbolNumber () const;
  // Atom factories generally want to work by indexing into an array most of
  // the time.  getDifferentAtoms says how big the array should be, and
  // myArrayPos says where this atom should be in the array.  For example,
  // there are 2 different values of type boolean, so if you make a new
  // kind of atom with a boolean flag added to the state, its configuration
  // should have a getDifferentAtoms method that returns 2 *
  // AtomConfiguration::getDifferentAtoms, and a myArrayPos method that returns
  // either AtomConfiguration::myArrayPos () or AtomConfiguration::myArrayPos
  // () + AtomConfiguration::getDifferentAtoms() depending on the value of the
  // boolean flag.
  virtual int getDifferentAtoms () const;
  virtual int myArrayPos () const;
  virtual int generation () const;
  String unParse () const;
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
  // Plugins that implement a way of drawing atoms should call this to register
  // themselves.  For instance, a factory named "XBallAndStickDrawer" should be
  // in the protocol "ObjectDrawer", and the registration code should call
  // registerDrawer ("BallAndStick", "Ball and Stick").  The first argument to
  // registerDrawer will get "X" stuck on the beginning and "Drawer" stuck on
  // the end to find the factory, and the second argument will be visible to
  // the user when he's configuring an Atom.
  static void registerDrawer (const String &shortName,
			      const String &prettyName);
};

#endif
