// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

// For cerr.
#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

// For set_new_handler.
#ifndef __new_h__
#include "new.h"
#endif

// For atexit, among others.
#ifndef __stdlib_h__
#include <stdlib.h>
#define __stdlib_h__
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __TopConfiguration_h__
#include "TopConfiguration.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __AnyFileSceneLoaderConfiguration_h__
#include "AnyFileSceneLoaderConfiguration.h"
#endif

namespace {
  // From Effective C++, Scott Meyers, page 22.
  void noMoreMemory ()
  {
    cerr << "No more memory!" << endl;
    abort ();
  }
  // Run the given command.  If it gets an error, use errorChatter to generate
  // an error message, print the message, and exit.
  void runCommand (TopLevel *tl,
		   const String &commandName, const String &errorChatter)
  {
    SP<RecursiveSlotValue> rsv =
      NEW (RecursiveSlotValue ("Action", commandName));
    SP<ActionConfiguration> ac =
      dynamic_cast <ActionConfiguration *> (rsv->getConfiguration());
    assert (ac);
    ac->setTopLevel (tl);
    SP<Action> a = dynamic_cast <Action *> (&*rsv->makeIt());
    if (a->isProblem()) {
      cerr << errorChatter << ":" << endl;
      cerr << a->getProblem () << endl;
      exit (1);
    }
  }
}

int main(int argc, const char **argv) {
  cout << "Fungimol version " VERSION << endl
       << "Copyright 2000 Tim Freeman" << endl
       << "Fungimol is free software, covered by the Gnu Library General "
       << "Public License" << endl
       << "and you are welcome to change it and/or distribute copies of it "
       << "under certain" << endl
       << "conditions." << endl
       << "There is absolutely no warranty for Fungimol." << endl
       << "Read the file " DOCHOME "/COPYING.txt for the copying conditions "
       << endl
       << "and details about the lack of warranty." << endl
       << "Visit the URL file:" DOCHOME "/index.html for other documentation."
       << endl;
  SP<TopConfiguration> theTop;
  {
    // Next line has to change for a Windows port.
    String WindowSystemName = "X";
    theTop = NEW (TopConfiguration (WindowSystemName + "TopLevel"));
  }
  set_new_handler (noMoreMemory);
  bool firstTime = true;
  // This loop goes around once each time an Action tells theTopLevel->mainLoop
  // to exit.  This typically happens when the Action changes the configuration
  // for making the TopLevel enough that a new TopLevel needs to be made, which
  // is typically when a new window system is specified.
  SP<TopLevel> theTopLevel = 0;
  for (;;) {
    {
      // Preserve the scene graph and the top level configuration from
      // one incarnation of the toplevel to the next.
      SP<SceneGraph> theSceneGraph = 0;
      if (theTopLevel) {
	theSceneGraph = theTopLevel->getSceneGraph ();
	theTop = theTopLevel->getConfiguration ();
      }
      theTopLevel =
	dynamic_cast <TopLevel *> (&*(theTop->getTopLevelSlot()->makeIt()));
      assert (theTopLevel);
      theTopLevel->setSceneGraph (theSceneGraph);
      theTopLevel->setConfiguration (theTop);
    }
    if (firstTime) {
      firstTime = false;
      // Make a new scene.
      if (argc == 1) {
	// Do nothing
      } else if (argc == 2) {
	// The scene generator for the new scene should read from the file with
	// the name given on the command line.
	SP<RecursiveSlotValue> rsv =
	  NEW (RecursiveSlotValue ("SceneLoader", "AnyFileSceneLoader"));
	SP<AnyFileSceneLoaderConfiguration> aslc =
	  dynamic_cast <AnyFileSceneLoaderConfiguration *>
	  (&*rsv->getConfiguration ());
	assert (argv [1]);
	// Not much point in having the newly-loaded stuff selected.
	aslc->setSelect (false);
	aslc->setFileName (argv[1]);
	aslc->setTakeDefaults (true);
	theTopLevel->getConfiguration()->setSceneLoaderSlot (rsv);
      } else {
	cerr << "Usage: " << argv[0] << " [<filename>]" << endl;
	exit (1);
      }
      runCommand (theTopLevel, "NewScene",
		  "Could not create the initial scene");
      runCommand (theTopLevel, "ViewScene",
		  "Failed to view the initial scene");
    }
    if (!theTopLevel->mainLoop ()) break;
  }
#ifndef NDEBUG
  theTopLevel = 0;
  theTop = 0;
  MemoryUtil::listLeaks();
#endif
}
