// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __BoundingSphere_h__
#include "BoundingSphere.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __FloatUtil_h__
#include "FloatUtil.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

namespace {
  // Change the viewpoint so the entire scene is visible and takes up most of
  // the screen.
  // Margin is the minimum unused fraction of the figure to have around the
  // figure. 
  const Float margin = 0.1;
  class ViewScene
    : public TypedFactory <ActionConfiguration, Action>
  {
  public:
    ViewScene ()
      : TypedFactory <ActionConfiguration, Action> ("ViewScene")
    {}
    SP<ActionConfiguration> typedDefaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Action> makeIt (ActionConfiguration *conf) const {
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      BoundingSphere bs = sg->graphicsBoundingSphere ();
      if (! bs.isBounded ()) {
	bs = BoundingSphere (10.0, Vec3 (0,0,0));
      }
      SP<Canvas> canvas = top->getCanvas ();
      // Set the rotation to the identity, so I can think about the origin in a
      // straightforward way.
      canvas->setRotation (Quaternion ());
      // minDim is the number of pixels available for drawing.
      int minDim = FloatUtil::max (1,
				   (int) (FloatUtil::min (canvas->getWidth (),
							  canvas->getHeight ())
					  * (1.0 - 2 * margin)));
      
      Float scale = minDim / (2 * bs.radius ());
      canvas->setScale (scale);
      // The center of the scene on the screen.
      Vec3 screenSphereCenter = canvas->transformWorldToRHScreen (bs.center());
      Vec3 desiredScreenSphereCenter = Vec3 (canvas->getWidth () / 2,
					     canvas->getHeight () / 2,
					     - bs.radius() * scale * 3);
      Vec3 originMove =
	(screenSphereCenter - desiredScreenSphereCenter) / scale;
      canvas->setOrigin (canvas->getOrigin () + originMove);
      assert ((desiredScreenSphereCenter -
	       canvas->transformWorldToRHScreen (bs.center())).lengthSquared ()
	      < 0.1);
      return NEW (Action ());
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (ViewScene ())), true);
}
