// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TransformConfiguration_h__
#define __TransformConfiguration_h__

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

class Vec3;
class Quaternion;
class Matrix4;
// This has information for configuring the motion of something.  First we
// will rotate around the given center, then we will do the translation.  It
// is up to the code using this to decide whether this is all in world
// coordinate or in screen coordinates.
class SpaceOrbEvent;
class TransformConfiguration
  : public ActionConfiguration
{
public:
  TransformConfiguration ();
  // The translation.
  Vec3 getTranslation () const;
  void setTranslation (const Vec3 &v);
  // The center that we rotate around.
  Vec3 getCenter () const;
  void setCenter (const Vec3 &v);
  // The rotation.
  Quaternion getRotation () const;
  void setRotation (const Quaternion &v);
  // Combine the center, rotation, and translation to get a matrix.
  // Multiplying this matrix on the right by a Vec3 will return the transformed
  // Vec3.
  Matrix4 getMatrix ();
  // Set the translation, center, and rotation according to the given
  // SpaceOrbEvent.
  // You should set the TopLevel before calling this.
  // This is only called from AnyOrbEvent.
  void parseOrbEvent (const SpaceOrbEvent *e);
  bool hasTheSameTypeAs (const Configuration *c) const;
  SP<Configuration> copy () const;
};
#endif
