// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SaveMovieConfiguration_h__
#define __SaveMovieConfiguration_h__

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

class String;
class SaveMovieConfiguration
  : public ActionConfiguration
{
public:
  SaveMovieConfiguration ();
  // The file name to write.  If we're writing multiple frames, we'll put them
  // all in one file, since the ppm format supports that.
  //
  // ImageMagick has a convert utility that can convert a multi-frame ppm file
  // into other things.  
  // 
  //    convert -delay 10 -loop 1000000 foo.ppm foo.gif
  //
  // is good.    
  //
  //    convert -delay 10 -loop 1000000 -map NETSCAPE:/dev/null foo.ppm foo.gif
  //
  // would probably load faster into Netscape, but convert doesn't do a good
  // job of dithering with this invocation, so the pictures look really ugly
  // under Netscape.
  // 
  // If I go find mpeg2encode, I could make mpeg movies.
  String getFileName () const;
  void setFileName (const String &name);
  // How many frames to write.  Default is 1.
  int getFrames () const;
  void setFrames (int frames);
  // How many frames to skip between frames that we write.  If this is 9, we'll
  // save every 10th frame.  Default is 0.
  int getSkip () const;
  void setSkip (int skip);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};
#endif
