// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SaveMovieConfiguration_h__
#include "SaveMovieConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __PositiveIntSlotValue_h__
#include "PositiveIntSlotValue.h"
#endif

#ifndef __StringSlotValue_h__
#include "StringSlotValue.h"
#endif

#ifndef __IntSlotValue_h__
#include "IntSlotValue.h"
#endif

namespace {
  String fileNameName () {
    return "PPM file name to write";
  }
  String framesName () {
    return "Frames to write";
  }
  String skipName () {
    return "Frames to skip between saved frames";
  }
}

SaveMovieConfiguration::SaveMovieConfiguration () {
  initializeSlot (fileNameName(), NEW (StringSlotValue ("Unspecified.ppm")));
  initializeSlot (framesName(), NEW (PositiveIntSlotValue (1)));
  initializeSlot (skipName(), NEW (IntSlotValue (0)));
}

String SaveMovieConfiguration::getFileName () const {
  return StringSlotValue::getSlot (this, fileNameName ());
}

void SaveMovieConfiguration::setFileName (const String &name) {
  StringSlotValue::setSlot (this, fileNameName (), name);
}

int SaveMovieConfiguration::getFrames () const {
  return PositiveIntSlotValue::getSlot (this, framesName ());
}

void SaveMovieConfiguration::setFrames (int frames) {
  PositiveIntSlotValue::setSlot (this, framesName (), frames);
}

int SaveMovieConfiguration::getSkip () const {
  return IntSlotValue::getSlot (this, skipName ());
}

void SaveMovieConfiguration::setSkip (int Skip) {
  IntSlotValue::setSlot (this, skipName (), Skip);
}

SP<Configuration> SaveMovieConfiguration::copy () const {
  return NEW (SaveMovieConfiguration (*this));
}

bool SaveMovieConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const SaveMovieConfiguration *> (c);
}
