// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

// For cout.
#ifndef __iostream_h__
#include <iostream.h>
#define __iostream_h__
#endif

#ifndef __StreamUtil_h__
#include "StreamUtil.h"
#endif

namespace {
  class ReportTimesFactory
    : public Factory
  {
  public:
    ReportTimesFactory ()
      : Factory ("ReportTimes")
      {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    void pushTwo (Dynavec <Dynavec <String> > &tableau,
		  const String &label, const String &value) const {
      tableau.push (Dynavec <String> ());
      Dynavec <String> &row = tableau[tableau.size()-1];
      row.push (label);
      row.push (value);
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      SP<ActionConfiguration> conf =
	dynamic_cast <ActionConfiguration *> (&*c);
      assert (conf);
      SP<TopLevel> top = conf->getTopLevel();
      Dynavec <Dynavec <String> > tableau;
      pushTwo (tableau, "Event", "Milliseconds");
      TopLevel::Times times = top->getTimes ();
      pushTwo (tableau, "Drawing the last frame", times.lastDrawTime);
      pushTwo (tableau, "Last timestep", times.lastIntTime);
      pushTwo (tableau, "Timesteps for last frame", times.totalIntTime);
      pushTwo (tableau, "Slop",
	       times.interFrameTime -
	       times.lastDrawTime -
	       times.totalIntTime);
      pushTwo (tableau, "Time between frames", times.interFrameTime);
      StreamUtil::printTableau (cout, tableau);
      // No errors possible.
      return NEW (Action ());
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (ReportTimesFactory ())),
   true);
} // namespace
