// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __TopConfiguration_h__
#include "TopConfiguration.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraphConfiguration_h__
#include "SceneGraphConfiguration.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

namespace {
  class NewSceneFactory
    : public Factory
  {
  public:
    NewSceneFactory ()
      : Factory ("NewScene")
      {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      SP<ActionConfiguration> conf =
	dynamic_cast <ActionConfiguration *> (&*c);
      assert (conf);
      SP<TopConfiguration> top = conf->getTopLevel()->getConfiguration();
      SP<SceneGraphConfiguration> sgc =
	dynamic_cast <SceneGraphConfiguration *>
	(top->getSceneGraphSlot()->getConfiguration());
      assert (sgc);
      sgc->setSceneGraph (0);
      SP<SceneGraph> sg =
	dynamic_cast <SceneGraph *> (&*top->getSceneGraphSlot()->makeIt());
      assert (sg);
#ifndef NDEBUG
      // We need the old SceneGraph to go away promptly so the
      // SelectionManager will see that its object links are invalid and make
      // new ones that point into the new SceneGraph.
      SP<SceneGraph> oldSg = conf->getTopLevel()->getSceneGraph ();
#endif
      conf->getTopLevel()->setSceneGraph (sg);
#ifndef NDEBUG
      if (oldSg) {
	// The only reference to the old SceneGraph should be the one we're
	// about to clobber.
	assert (1 == oldSg->count());
	oldSg = 0;
      }
#endif
      SP<RecursiveSlotValue> rs = top->getSceneLoaderSlot ();
      assert (rs);
      SP<ActionConfiguration> ac =
	dynamic_cast <ActionConfiguration *> (rs->getConfiguration ());
      assert (ac);
      ac->setTopLevel (conf->getTopLevel());
      // Next step actually creates the scene.
      SP<Configurable> slc = rs->makeIt ();
      assert (slc);
      // Avoid reference cycle and thus memory leak.
      // FIXME I do not think this is needed any more.
      // ac->setTopLevel (0);
      return slc;
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (NewSceneFactory ())),
   true);
} // namespace
