// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

namespace {
  // Create a link between the two selected objects, or between the one
  // selected object and the object under the mouse.
  // Refuse to create a link from an object to itself.
  // Send a message and do not create any link if there is already a link
  // between the two objects.
  class MakeLink
    : public TypedFactory <ActionConfiguration, Action>
  {
  public:
    MakeLink ()
      : TypedFactory <ActionConfiguration, Action> ("MakeLink")
    {}
    SP<ActionConfiguration> typedDefaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    void makeLink (ActionConfiguration *conf, int o1, int o2, Action *result)
      const
    {
      if (o1 == o2) {
	result->setProblem ("I refuse to make a link from an object to itself");
      } else {
	SP<TopLevel> top = conf->getTopLevel ();
	SP<SceneGraph> sg = top->getSceneGraph ();
	SP<LinkManager> lm = sg->getLinkManager ();
	if (lm->findLink (o1, o2) && lm->findLink (o2, o1)) {
	  result->setProblem ("The two objects are already linked");
	} else {
	  // If one was linked to the other, but the other wasn't linked to the
	  // one, we silently make things symmetric.
	  lm->addNewLink (o1, o2);
	  lm->addNewLink (o2, o1);
	}
      }
    }
    SP<Action> makeIt (ActionConfiguration *conf) const {
      Dynavec <int> selection;
      SelectionManager::getSelection (selection);
      SP<Action> result = NEW (Action ());
      if (1 == selection.size ()) {
	SP<TopLevel> top = conf->getTopLevel ();
	int index;
	Vec3 intersectionPoint;
	if (top->findUnderMouse (index, intersectionPoint)) {
	  makeLink (conf, selection[0], index, result);
	  if (!result->isProblem ()) {
	    selection [0] = index;
	    SelectionManager::setSelection (top->getSceneGraph (), selection);
	  }
	} else {
	  result->setProblem ("Please point the mouse at the object you want "
			      "to link to and try again");
	}
      } else if (2 == selection.size ()) {
	makeLink (conf, selection [0], selection [1], result);
      } else {
	result->setProblem ("Please select two objects to link, or select one "
			    "and point the mouse at the other, and try again");
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("KeyboardMouseAction", NEW (MakeLink ())),
   true);
}
