// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __MacroConfiguration_h__
#include "MacroConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __VectorSlotValue_h__
#include "VectorSlotValue.h"
#endif

namespace {
  String commandsName () {
    return "Commands";
  }
}

struct MacroConfiguration::MacroConfigurationData {
  String m_protocol;
};

MacroConfiguration::MacroConfiguration (const String &protocol)
  : m_data (NEW (MacroConfigurationData ()))
{
  m_data->m_protocol = protocol;
  initializeSlot (commandsName (),
		  NEW (VectorSlotValue
		       (NEW (RecursiveSlotValue (protocol, "DoNothing")))));
}

MacroConfiguration::MacroConfiguration (const MacroConfiguration &v)
  : ActionConfiguration (v),
    m_data (NEW (MacroConfigurationData (*v.m_data)))
{}

MacroConfiguration::~MacroConfiguration () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<Configuration> MacroConfiguration::copy () const
{
  return NEW (MacroConfiguration (*this));
}

bool MacroConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const MacroConfiguration *> (c);
}

SP<const VectorSlotValue> MacroConfiguration::getCommandVector () const {
  return VectorSlotValue::getSlotValue (this, commandsName ());
}

SP<VectorSlotValue> MacroConfiguration::getCommandVector () {
  return VectorSlotValue::getSlotValue (this, commandsName ());
}

void MacroConfiguration::setCommandVector (VectorSlotValue *vsv) {
  VectorSlotValue::setSlotValue (this, commandsName (), vsv);
}

void MacroConfiguration::setCommandVector
(const Dynavec <SP<RecursiveSlotValue> > &v)
{
  Dynavec <SP <SlotValue> > vv;
  for (int i = 0; i < v.size(); i++) {
    vv.push (&*v[i]);
  }
  VectorSlotValue::setSlotValue (this, commandsName (),
				 NEW (VectorSlotValue
				      (NEW (RecursiveSlotValue
					    (m_data->m_protocol,
					     "DoNothing")),
				       vv)));
}

