// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Macro_h__
#define __Macro_h__

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __MacroConfiguration_h__
#include "MacroConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

class String;
class RecursiveSLotValue;
class Configuration;
class Macro
  // Do the commands in the configuration in order, until we get to the end or
  // one of the commands returns an error (that is, an Action for which
  // isProblem() returns true).
  : public TypedFactory <MacroConfiguration, Action>
{
  struct MacroData;
  MacroData *m_data;
public:
  Macro (const String &protocol);
  ~Macro ();
  SP<MacroConfiguration> typedDefaultConfiguration () const;
  String getPrettyName (const Configuration *c) const;
  SP<Action> makeIt (MacroConfiguration *mc) const;
  static SP<RecursiveSlotValue> mkMacro
  (const String &protocol,
   const Dynavec <SP<RecursiveSlotValue> > &rsv);
  static SP<RecursiveSlotValue> mkMacro
  (const String &protocol, const Dynavec <String> &named);
};

#endif
