// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Macro_h__
#include "Macro.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __MacroConfiguration_h__
#include "MacroConfiguration.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __VectorSlotValue_h__
#include "VectorSlotValue.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

struct Macro::MacroData {
  String m_protocol;
};

Macro::Macro (const String &protocol)
  : TypedFactory <MacroConfiguration, Action> ("Macro"+protocol),
  m_data (NEW (MacroData ()))
{
  m_data->m_protocol = protocol;
}

Macro::~Macro ()
{
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<MacroConfiguration> Macro::typedDefaultConfiguration () const {
  return NEW (MacroConfiguration (m_data->m_protocol));
}

SP<Action> Macro::makeIt (MacroConfiguration *mc) const {
  // FIXME This fails if an action in this macro grabs the input device.
  // To do it right, we'd have to fetch and massage the current grab after each
  // step in the macro.
  SP<VectorSlotValue> vsv = mc->getCommandVector ();
  for (int i = 0; i < vsv->size(); i++) {
    SP<RecursiveSlotValue> rsv =
      dynamic_cast <RecursiveSlotValue *> (&*((*vsv)[i]));
    assert (rsv);
    SP<ActionConfiguration> ac =
      dynamic_cast <ActionConfiguration *> (&*rsv->getConfiguration ());
    assert (ac);
    ac->setTopLevel (mc->getTopLevel());
    SP<Configurable> result = rsv->makeIt ();
    assert (result);
    SP<Action> action = dynamic_cast <Action *> (&*result);
    if (action->isProblem ()) {
      return action;
    }
  }
  return NEW (Action ());
}

SP<RecursiveSlotValue> Macro::mkMacro
(const String &protocol,
 const Dynavec <SP<RecursiveSlotValue> > &rsv) {
  SP<RecursiveSlotValue> result =
    NEW (RecursiveSlotValue (protocol, NEW (Macro (protocol))));
  SP<MacroConfiguration> mc = NEW (MacroConfiguration (protocol));
  mc->setCommandVector (rsv);
  result->setConfiguration (&*mc);
  return result;
}

SP<RecursiveSlotValue> Macro::mkMacro
(const String &protocol, const Dynavec <String> &names)
{
  Dynavec <SP<RecursiveSlotValue> > rsvs;
  for (int i = 0; i < names.size(); i++) {
    rsvs.push (NEW (RecursiveSlotValue (protocol, names[i])));
  }
  return mkMacro (protocol, rsvs);
}

String Macro::getPrettyName (const Configuration *c) const {
  SP<const MacroConfiguration> mc =
    dynamic_cast <const MacroConfiguration *> (c);
  assert (mc);
  SP<const VectorSlotValue> vsv = mc->getCommandVector ();
  String result;
  if (0 == vsv->size()) {
    result = "a do-nothing macro";
  } else {
    result = (*vsv)[0]->unParse ();
    for (int i = 1; i < vsv->size(); i++) {
      result += " and "+(*vsv) [i]->unParse ();
    }
  }
  return result;
}

namespace {
  bool useless = (FactoryTable::store ("Action", NEW (Macro ("Action"))),
		  FactoryTable::store ("KeyboardMouseAction",
				       NEW (Macro ("KeyboardMouseAction"))),
		  FactoryTable::store ("SpaceOrbAction",
				       NEW (Macro ("SpaceOrbAction"))),
		  // Have to add new fluff here for each new subclass of
		  // Action, unfortunately.
		  true);
}
