// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __LoadPluginConfiguration_h__
#include "LoadPluginConfiguration.h"
#endif

#ifndef __dlfcn_h__
#include <dlfcn.h>
#define __dlfcn_h__
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

namespace {
  class LoadPlugin
    : public TypedFactory <LoadPluginConfiguration, Action>
  {
  public:
    LoadPlugin ()
      : TypedFactory <LoadPluginConfiguration, Action> ("LoadPlugin")
    {}
    SP<LoadPluginConfiguration> typedDefaultConfiguration () const {
      return NEW (LoadPluginConfiguration ());
    }
    SP<Action> makeIt (LoadPluginConfiguration *conf) const {
      String fileName = conf->getFileName ();
      void *handle = dlopen (&*fileName, RTLD_NOW);
      SP<Action> result = NEW (Action ());
      if (!handle) {
	result->setProblem (dlerror ());
      }
      return result;
    }
  };
  bool useless = (FactoryTable::store ("Action", NEW (LoadPlugin ())),
		  true);
}
