// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Identify_h__
#include "Identify.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __ObjectLink_h__
#include "ObjectLink.h"
#endif

namespace {
  // Loop through the selection, or through the whole scene if nothing is
  // selected.  If we find an object that is near any other object in the
  // scene, identify the two nearby objects.
  // FIXME Would be better to have the threshhold for "near" configurable.
  // A third of an Angstrom is near today.
  const Float near = 0.3;
  const Float nearSquared = near * near;
  class IdentifyNear
    : public TypedFactory <ActionConfiguration, Action>
  {
  public:
    IdentifyNear ()
      : TypedFactory <ActionConfiguration, Action> ("IdentifyNear")
    {}
    SP<ActionConfiguration> typedDefaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Action> makeIt (ActionConfiguration *conf) const {
      SP<Action> result = NEW (Action ());
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      Dynavec <ObjectLink> selection;
      SelectionManager::getSelectionLinks (selection);
      if (0 == selection.size ()) {
	for (int i = 0; i < sg->maxIndex(); i++) {
	  if (sg->object (i)->isSelectable()) {
	    selection.push (ObjectLink (sg, i));
	  }
	}
      }
      int identifications = 0;
      for (int i = 0; i < selection.size(); i++) {
	ObjectLink si = selection [i];
	const Vec3 iCenter = si.boundingSphereCenter ();
	for (int j = 0; j < sg->maxIndex(); j++) {
	  if (sg->object(j) && sg->object(j)->isSelectable() &&
	      j != si.getIndex()) {
	    const Vec3 jCenter =
	      sg->object (j)->boundingSphereCenter (sg->objectState (j));
	    if ((iCenter - jCenter).lengthSquared() <= nearSquared) {
	      identifications++;
	      Identify::identify (sg, si.getIndex(), j);
	    }
	  }
	}
      }
      if (identifications) {
	result->setMessage (String ("Did ")+identifications+
			    " identifications");
      } else {
	result->setMessage ("Found nothing to identify");
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (IdentifyNear ())),
   true);
}
