// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __Identify_h__
#include "Identify.h"
#endif

namespace {
  // Identify two objects.  Delete one of them, and give the other all of the
  // links that came from the deleted one.
  // Can't identify an object with itself.
  // If we picked up one of them because it was under the mouse, the old
  // selected object is the one that's deleted, and the object presently under
  // the mouse will be the new one that will be selected.
  class IdentifyAction
    : public TypedFactory <ActionConfiguration, Action>
  {
  public:
    IdentifyAction ()
      : TypedFactory <ActionConfiguration, Action> ("IdentifyAction")
    {}
    SP<ActionConfiguration> typedDefaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Action> makeIt (ActionConfiguration *conf) const {
      Dynavec <int> selection;
      SelectionManager::getSelection (selection);
      SP<Action> result = NEW (Action ());
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      if (1 == selection.size ()) {
	int index;
	Vec3 intersectionPoint;
	if (top->findUnderMouse (index, intersectionPoint)) {
	  if (selection [0] == index) {
	    result->setProblem ("Can't identify an object with itself");
	  }
	  if (!result->isProblem ()) {
	    Identify::identify (sg, selection[0], index);
	    selection [0] = index;
	    SelectionManager::setSelection (top->getSceneGraph (), selection);
	  }
	} else {
	  result->setProblem ("Please point the mouse at the object you want "
			      "to identify the selection with, and try again");
	}
      } else if (2 == selection.size ()) {
	if (selection [0] == selection [1]) {
	  result->setProblem ("Can't identify an object with itself");
	} else {
	  Identify::identify (sg, selection [0], selection [1]);
	}
      } else {
	result->setProblem
	  ("Please select two objects to identify, or select "
	   "one and point the mouse at the other, and try again");
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("KeyboardMouseAction", NEW (IdentifyAction ())),
   true);
}
