// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Identify_h__
#include "Identify.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

void Identify::identify (SceneGraph *sg, int o1, int o2)
{
  assert (o1 != o2);
  // We'll delete o1 and keep o2.
  SP<LinkManager> lm = sg->getLinkManager ();
  // Save a safe copy of the link list, since we'll be editing links.
  Dynavec <int> links;
  {
    int count;
    const int *tmpLinks;
    lm->getLinks (o1, count, tmpLinks);
    for (int i = 0; i < count; i++) {
      links.push (tmpLinks [i]);
    }
  }
  for (int i = 0; i < links.size(); i++) {
    const int l = links [i];
    if (-1 == l) {
      // Do nothing.
    } else if (o2 == l) {
      // Do nothing.
    } else if (lm->findLink (l, o2)) {
      // There's a link from l to o1, and already a link from l to o2.
      lm->removeLink (o1, l);
      lm->removeLink (l, o1);
    } else {
      lm->addNewLink (o2, l);
      lm->addNewLink (l, o2);
      lm->removeLink (o1, l);
      lm->removeLink (l, o1);
    }
  }
  // C++ code that pointed at o1 should now point at o2.
  lm->redirectObjectLinks (o1, o2);
  sg->deleteObject (o1);
}
