// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ConfigureAndRunConfiguration_h__
#include "ConfigureAndRunConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

namespace {
  String rsvName () {
    return "The action to take";
  }
}

ConfigureAndRunConfiguration::ConfigureAndRunConfiguration
(const String &protocol)
{
  initializeSlot (rsvName (),
		  NEW (RecursiveSlotValue (protocol, "DoNothing")));
}

SP<RecursiveSlotValue> ConfigureAndRunConfiguration::getRSV () {
  return RecursiveSlotValue::getSlotValue (this, rsvName());
}

SP<const RecursiveSlotValue> ConfigureAndRunConfiguration::getRSV () const {
  return RecursiveSlotValue::getSlotValue (this, rsvName());
}

void ConfigureAndRunConfiguration::setRSV (RecursiveSlotValue *rsv) {
  RecursiveSlotValue::setSlotValue (this, rsvName(), rsv);
}

SP<Configuration> ConfigureAndRunConfiguration::copy () const {
  // Default copy constructor is sufficient.
  return NEW (ConfigureAndRunConfiguration (*this));
}

bool ConfigureAndRunConfiguration::hasTheSameTypeAs
(const Configuration *c) const {
  return 0 != dynamic_cast <const ConfigureAndRunConfiguration *> (c);
}
