// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ConfigureAndRunConfiguration_h__
#include "ConfigureAndRunConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __TextConfigurationEditor_h__
#include "TextConfigurationEditor.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

namespace {
  class ConfigureAndRun
    : public TypedFactory <ConfigureAndRunConfiguration, Action>
  {
  public:
    ConfigureAndRun ()
      : TypedFactory <ConfigureAndRunConfiguration, Action> ("ConfigureAndRun")
    {}
    SP<ConfigureAndRunConfiguration> typedDefaultConfiguration () const {
      return NEW (ConfigureAndRunConfiguration ("Action"));
    }
    SP<Action> makeIt (ConfigureAndRunConfiguration *carc) const {
      TextConfigurationEditor::edit (carc->getRSV()->getConfiguration());
      SP<ActionConfiguration> ac = 
	dynamic_cast <ActionConfiguration *>
	(&*carc->getRSV()->getConfiguration());
      assert (ac);
      ac->setTopLevel (carc->getTopLevel());
      SP<Action> result = dynamic_cast <Action *> (&*carc->getRSV()->makeIt ());
      assert (result);
      return result;
    }
    String typedGetPrettyName (const ConfigureAndRunConfiguration *c) const {
      return String("Configure and run ")+c->getRSV()->unParse();
    }
  };
  bool useless = (FactoryTable::store ("Action", NEW (ConfigureAndRun ())),
		  true);
}
