// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __ScaleConfiguration_h__
#include "ScaleConfiguration.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __Canvas_h__
#include "Canvas.h"
#endif

namespace {
  class BumpScale
    : public Factory
  {
  public:
    BumpScale ()
      : Factory ("BumpScale")
    {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ScaleConfiguration ());
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      SP<ScaleConfiguration> conf =
	dynamic_cast <ScaleConfiguration *> (&*c);
      assert (conf);
      Float scale = conf->getScale ();
      SP<Canvas> vo = conf->getTopLevel()->getCanvas();
      // FIXME scale around the (x,y) coordinates of the mouse.
      // This requires being able to do matrix inversion to infer world
      // coordinates from mouse coordinates.  I can do that now, but not worth
      // fixing for this release.
      vo->setScale (vo->getScale () * scale);
      // No errors possible.
      return NEW (Action ());
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (BumpScale ())),
   true);
} // namespace
