// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __AnyFileSceneWriterConfiguration_h__
#define __AnyFileSceneWriterConfiguration_h__

#ifndef __SceneWriterConfiguration_h__
#include "SceneWriterConfiguration.h"
#endif

class AnyFileSceneWriterConfiguration
  : public SceneWriterConfiguration
{
  struct AnyFileSceneWriterConfigurationData;
  AnyFileSceneWriterConfigurationData *m_data;
public:
  AnyFileSceneWriterConfiguration ();
  ~AnyFileSceneWriterConfiguration ();
  // We look at the extension of the file name to go find a factory to use to
  // do the actual writing, and that factory will have a configuration.  We'll
  // use the assignment operator to copy from our SceneWriterConfiguration into
  // that configuration to initialize the filename and so forth, but the
  // configuration may have other fields.  If take defaults is true, then we
  // just leave those other fields as the default value.  Otherwise we interact
  // with the user to invite him to reconfigure them.
  // Since this configuration field says whether we should interact with the
  // user, there isn't any point in making it available for reconfiguration by
  // the user.
  bool getTakeDefaults () const;
  void setTakeDefaults (bool defaults);
  AnyFileSceneWriterConfiguration (const AnyFileSceneWriterConfiguration &conf);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};
#endif
