// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __AnyFileSceneWriterConfiguration_h__
#include "AnyFileSceneWriterConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

struct AnyFileSceneWriterConfiguration::AnyFileSceneWriterConfigurationData {
  bool m_takeDefaults;
  AnyFileSceneWriterConfigurationData ()
    : m_takeDefaults (false)
  {}
};

AnyFileSceneWriterConfiguration::AnyFileSceneWriterConfiguration ()
  : m_data (NEW (AnyFileSceneWriterConfigurationData ()))
{
}

AnyFileSceneWriterConfiguration::AnyFileSceneWriterConfiguration
(const AnyFileSceneWriterConfiguration &conf)
  : SceneWriterConfiguration (conf),
    m_data (NEW (AnyFileSceneWriterConfigurationData (*(conf.m_data))))
{
}

AnyFileSceneWriterConfiguration::~AnyFileSceneWriterConfiguration () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

bool AnyFileSceneWriterConfiguration::getTakeDefaults () const {
  return m_data->m_takeDefaults;
}

void AnyFileSceneWriterConfiguration::setTakeDefaults (bool defaults) {
  m_data->m_takeDefaults = defaults;
}

SP<Configuration> AnyFileSceneWriterConfiguration::copy () const {
  return NEW (AnyFileSceneWriterConfiguration (*this));
}
  
bool AnyFileSceneWriterConfiguration::hasTheSameTypeAs
(const Configuration *c) const {
  return 0 != dynamic_cast <const AnyFileSceneWriterConfiguration *> (c);
}  
