// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __SceneWriterConfiguration_h__
#include "SceneWriterConfiguration.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __TextConfigurationEditor_h__
#include "TextConfigurationEditor.h"
#endif

#ifndef __StringUtil_h__
#include "StringUtil.h"
#endif

#ifndef __AnyFileSceneWriterConfiguration_h__
#include "AnyFileSceneWriterConfiguration.h"
#endif

namespace {
  // Cut-and-paste job, starting with AnyFileSceneLoader.cpp.

  // If a file ends in an extension, such as foo.pdb ends in pdb, we'll take
  // the extension, convert to upper case, concatenate "SceneWriter", and try
  // to find the resulting class in the protocol "SceneWriter", such as
  // "PDBSceneWriter" if we started with foo.pdb.  Then we copy the fields from
  // our configuration into the fields of the SceneWriter's default
  // configuration, then we let the user edit that configuration some more,
  // then we go ahead and load it.
  // 
  // FIXME If read-only slots are implemented, we should mark the slots that
  // are already set from our configuration as read-only in the configuration
  // of the XXXSceneWriter we're configuring, and rig the configuration editor
  // so that it returns immediately if there aren't any writable slots to
  // edit.  This would decrease the redundant input from the user.
  typedef TypedFactory <AnyFileSceneWriterConfiguration, Action> TF;
  class AnyFileSceneWriter
    : public TF
  {
  public:
    AnyFileSceneWriter ()
      : TF ("AnyFileSceneWriter")
    {}
    SP<AnyFileSceneWriterConfiguration> typedDefaultConfiguration () const {
      return NEW (AnyFileSceneWriterConfiguration ());
    }
    SP<Action> makeIt (AnyFileSceneWriterConfiguration *conf) const {
      SP<Action> result = NEW (Action ());
      String fileName = conf->getFileName ();
      const String extension = StringUtil::extension (fileName);
      if ("" == extension) {
	result->setProblem ("No extension in "+fileName+
			    ", so can't decide how to write it.");
      }
      SP<Factory> f;
      String newClass;
      if (!result->isProblem ()) {
	newClass = extension.upcase()+"SceneWriter";
	f = FactoryTable::load ("SceneWriter", newClass);
	if (!f) {
	  result->setProblem ("Can't find a factory in SceneWriter named "
			      + newClass);
	}
      }
      SP<SceneWriterConfiguration> fslc;
      if (!result->isProblem ()) {
	SP<Configuration> subConf = f->defaultConfiguration();
	fslc = dynamic_cast <SceneWriterConfiguration *> (&*subConf);
	if (!fslc) {
	  result->setProblem ("The default configuration for "+newClass+
			      " is not a SceneWriterConfiguration");
	}
      }
      if (!result->isProblem ()) {
	*fslc = *conf;
	if (!conf->getTakeDefaults ()) {
	  TextConfigurationEditor::edit (&*fslc);
	}
	SP<Configurable> fluff = f->makeIt (&*fslc);
	result = dynamic_cast <Action *> (&*fluff);
	assert (result);
      }
      return result;
    }
  };
  const bool useless =
  (FactoryTable::store ("SceneWriter", NEW (AnyFileSceneWriter ())),
   true);
}
