// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __AnyFileSceneLoaderConfiguration_h__
#include "AnyFileSceneLoaderConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __FileSceneLoaderConfiguration_h__
#include "FileSceneLoaderConfiguration.h"
#endif

struct AnyFileSceneLoaderConfiguration::AnyFileSceneLoaderConfigurationData {
  bool m_takeDefaults;
  AnyFileSceneLoaderConfigurationData ()
    : m_takeDefaults (false)
  {}
};

AnyFileSceneLoaderConfiguration::AnyFileSceneLoaderConfiguration ()
  : m_data (NEW (AnyFileSceneLoaderConfigurationData ()))
{
}

AnyFileSceneLoaderConfiguration::AnyFileSceneLoaderConfiguration
(const AnyFileSceneLoaderConfiguration &conf)
  : FileSceneLoaderConfiguration (conf),
    m_data (NEW (AnyFileSceneLoaderConfigurationData (*(conf.m_data))))
{
}

AnyFileSceneLoaderConfiguration::~AnyFileSceneLoaderConfiguration () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

bool AnyFileSceneLoaderConfiguration::getTakeDefaults () const {
  return m_data->m_takeDefaults;
}

void AnyFileSceneLoaderConfiguration::setTakeDefaults (bool defaults) {
  m_data->m_takeDefaults = defaults;
}

SP<Configuration> AnyFileSceneLoaderConfiguration::copy () const {
  return NEW (AnyFileSceneLoaderConfiguration (*this));
}
  
bool AnyFileSceneLoaderConfiguration::hasTheSameTypeAs
(const Configuration *c) const {
  return 0 != dynamic_cast <const AnyFileSceneLoaderConfiguration *> (c);
}  
