// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

namespace {
  String commandName () {
    return "Command to execute";
  }
  class AnyCommandConfiguration
    : public ActionConfiguration
  {
  public:
    AnyCommandConfiguration ()
    {
      initializeSlot (commandName (),
		      NEW (RecursiveSlotValue ("Action", "DoNothing")));
    }
    SP<RecursiveSlotValue> getCommand () {
      return RecursiveSlotValue::getSlotValue (this, commandName ());
    }
    SP<const RecursiveSlotValue> getCommand () const {
      return RecursiveSlotValue::getSlotValue (this, commandName ());
    }
    
    void setCommand (RecursiveSlotValue *rsv) {
      RecursiveSlotValue::setSlotValue (this, commandName (), rsv);
    }
    
    SP<Configuration> copy () const {
      return NEW (AnyCommandConfiguration (*this));
    }
    bool hasTheSameTypeAs (const Configuration *c) const {
      return 0 != dynamic_cast <const AnyCommandConfiguration *> (c);
    }
  };
  class AnyCommand
    : public TypedFactory <AnyCommandConfiguration, Action>
  {
  public:
    AnyCommand ()
      : TypedFactory <AnyCommandConfiguration, Action> ("AnyCommand")
    {}
    SP<AnyCommandConfiguration> typedDefaultConfiguration () const {
      return NEW (AnyCommandConfiguration ());
    }
    SP<Action> makeIt (AnyCommandConfiguration *conf) const {
      SP<RecursiveSlotValue> rsv = conf->getCommand ();
      SP<ActionConfiguration> ac =
	dynamic_cast <ActionConfiguration *> (&*rsv->getConfiguration ());
      ac->setTopLevel (conf->getTopLevel ());
      SP<Configurable> c = rsv->makeIt ();
      SP<Action> a = dynamic_cast <Action *> (&*c);
      // If it was null before the dynamic_cast, it is okay for it to be null
      // after.
      assert (!c || a);
      return a;
    }
  };
  const bool useless = (FactoryTable::store ("Action", NEW (AnyCommand ())),
			true);
}
