

#include <forms.h>
#include "wavesim.h"
#include "wavesim_func.h"

//********************* XPMs **********************************************************


#include "xpms/wavesim.xpm"

#include "xpms/dialog_box.xpm"
#include "xpms/simu_dlg.xpm"
#include "xpms/main_geom.xpm"

#include "xpms/pencil3.xpm"
#include "xpms/recycle.xpm"

#include "xpms/simu_restart.xpm"
#include "xpms/simu_play.xpm"
#include "xpms/simu_stop.xpm"
#include "xpms/simu_step.xpm"


//*************************************************************************************


const char *scale_text=" 10+2 | 10+1 | 1 | 10-1 | 10-2 | 10-3 | 10-4 | 10-5 | 10-6 | 10-7 | 10-8 | 10-9";
                              
                              
//*************************************************************************************                              


void ini_form_Parameters(FD_Parameters *p)
{
  int cont;
  
  for (cont=0;cont<5;cont++) fl_addto_choice(p->Scale[cont],scale_text);

  fl_set_slider_step(fd_Parameters->Scroll[GSMAXITE_PARAM],1);
  
}


void ini_form_Main(FD_Main *p)
{
 char *menu_file="New|Load Bitmap ...|Save Bitmap ...|Load ...|Save |Save As ...|Quit";
 char *menu_view="Parameters ...|Geometry ...|Simulation ...";   //,"Render ...","Wave ..."};
 char *menu_help="Overview ...|Instruction ...|About WaveSim ...";

 fl_addto_menu(p->Main_Menu[FILE_MENU],menu_file);    
 fl_addto_menu(p->Main_Menu[VIEW_MENU],menu_view); 
 fl_addto_menu(p->Main_Menu[HELP_MENU],menu_help); 
 
  
 fl_set_pixmapbutton_data(p->Fast_Bar[PARAM_DLG],dialog_box_xpm); 
 fl_set_pixmapbutton_data(p->Fast_Bar[SIMU_DLG],simu_dlg_xpm); 
 fl_set_pixmapbutton_data(p->Fast_Bar[GEOM_DLG],main_geom_xpm); 
 
 fl_set_pixmapbutton_data(p->Tool_Bot[POINT_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[LINE_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[RECT_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[FILLRECT_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[ELLIP_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[FILLELLIP_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[FILL_TOOL],pencil3_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[GEOM_TOOL],main_geom_xpm); 
 fl_set_pixmapbutton_data(p->Tool_Bot[CLEAR_TOOL],recycle_xpm);
 
 fl_set_button(p->Tool_Bot[Main_Data.draw_tool ],1);
 
 fl_set_pixmap_data(p->Main_Logo,wavesim_xpm);
  
 fl_set_object_color(p->Design_Board,FL_DARKCYAN,FL_BLACK);
 
 fl_set_fselector_fontsize(14);
 fl_set_goodies_font(FL_NORMAL_STYLE,14);
      
}

void ini_form_Geometry(FD_Geometry *p)
{
 int cont;
  
 for (cont=0;cont<3;cont++) fl_addto_choice(p->Scale[cont],scale_text);
   
  fl_set_slider_step(fd_Geometry->Scroll[CUANTIZEX_GEOM],1);
  fl_set_slider_step(fd_Geometry->Scroll[CUANTIZEY_GEOM],1);
    
}


void ini_form_Simulation(FD_Simulation *p)
{

 fl_set_pixmapbutton_data(p->Control_Bot[PLAY_SIMU],simu_play_xpm);
 fl_set_pixmapbutton_data(p->Control_Bot[STEP_SIMU],simu_step_xpm);
 fl_set_pixmapbutton_data(p->Control_Bot[RESTART_SIMU],simu_restart_xpm);
 
/*
 Simu_Data.min_color.pixel=fl_mapcolor(Simu_Data.min_color.index,Simu_Data.min_color.r,
                                       Simu_Data.min_color.g,Simu_Data.min_color.b);
 Simu_Data.zero_color.pixel=fl_mapcolor(Simu_Data.zero_color.index,Simu_Data.zero_color.r,
                                        Simu_Data.zero_color.g,Simu_Data.zero_color.b);
 Simu_Data.max_color.pixel=fl_mapcolor(Simu_Data.max_color.index,Simu_Data.max_color.r,
                                       Simu_Data.max_color.g,Simu_Data.max_color.b);
 Simu_Data.set_colors();
 
 fl_set_object_color(p->Muestra_Col[SIMU_COLMIN],Simu_Data.min_color.index,p->Muestra_Col[SIMU_COLMIN]->col2);
 fl_set_object_color(p->Muestra_Col[SIMU_COLZERO],Simu_Data.zero_color.index,p->Muestra_Col[SIMU_COLZERO]->col2);
 fl_set_object_color(p->Muestra_Col[SIMU_COLMAX],Simu_Data.max_color.index,p->Muestra_Col[SIMU_COLMAX]->col2);

*/

}


void set_play_button(int p)
{
  if (p==TRUE) fl_set_pixmapbutton_data(fd_Simulation->Control_Bot[PLAY_SIMU],simu_play_xpm);
  else fl_set_pixmapbutton_data(fd_Simulation->Control_Bot[PLAY_SIMU],simu_stop_xpm);

}


//*******************************************************************************************


void ini_form_Help(FD_Help *p)
{

  fl_set_browser_fontsize(fd_Help->Help_Browser,14);

}

void ini_form_About(FD_About *p)
{

}

//********************************************


void ini_form_Render(FD_Render *p)
{

  fl_add_canvas_handler(p->Render_Board, Expose, Render_Board_Expose, 0);
  
}


//********************************************


void ini_form_Wave(FD_Wave *p)
{

  
}

