

#include "wavesim.h"
#include "membrasim.h"
#include "wavesim_func.h"
#include "wavesim_ini.h"


#include <math.h>

//********************************************************************************

const float scale_value[12]= {100,10,1,0.1,1e-2,1e-3,1e-4,1e-5,1e-6,1e-7,1e-8,1e-9};


int Noname_File=TRUE;
int File_Modif=FALSE;

int Param_Modif=FALSE;
int Geom_Modif=FALSE;

int Main_Show=FALSE;
int Param_Show=FALSE;
int Geom_Show=FALSE;
int Simu_Show=FALSE;
int Render_Show=FALSE;
int Wave_Show=FALSE;
int Help_Show=FALSE;

int Simu_Play=FALSE;
int Simu_Timeout_ID=0;



//******************* Variables del menu Main ************************************

int drawing=FALSE;
int mx1=0,my1=0,mx2=0,my2=0;


//******************* Variables Comunes ******************************************

char ruta_archivo[64]="./noname.wsm";
char nombre_archivo[64]="noname.wsm";
char nombre_directory[64]=".";


simu_data Simu_Data;
main_data Main_Data;
render_data Render_Data;
ecu_onda Simu_Onda;
cuadricula DBoard;

//********************************************************************************
//********************************************************************************
//********************************************************************************


void simu_data::crea()
{

  nx=DBoard.get_nx();
  ny=DBoard.get_ny();
  
  crea_color_map();
  crea_image();

}


void simu_data::destroy()
{
  nx=ny=sx=sy=0;
  destroy_image();
  destroy_color_map();
}  



void simu_data::set_defaults()
{

  level=0.3;
  thickness=5;
  visu=POSITION_SIMU;
  scale_color=60;
  zoom=4;
  image_x=0;
  image_y=0;
  mouse_x=0;
  mouse_y=0;
  steps=0;

  image=NULL;

  min_color.set(32,80,200,0,0);
  zero_color.set(32+SIMU_COLORS,30,50,240,0);
  max_color.set(31+2*SIMU_COLORS,235,12,65,0);
  
  FD_Simulation *p=fd_Simulation;
  
  fl_set_object_color(p->Muestra_Col[SIMU_COLMIN],min_color.index,p->Muestra_Col[SIMU_COLMIN]->col2);
  fl_set_object_color(p->Muestra_Col[SIMU_COLZERO],zero_color.index,p->Muestra_Col[SIMU_COLZERO]->col2);
  fl_set_object_color(p->Muestra_Col[SIMU_COLMAX],max_color.index,p->Muestra_Col[SIMU_COLMAX]->col2);

  set_colors();

}



void simu_data::set_colors()
{
  float mr=(zero_color.r-min_color.r)/(float)SIMU_COLORS;
  float mg=(zero_color.g-min_color.g)/(float)SIMU_COLORS;
  float mb=(zero_color.b-min_color.b)/(float)SIMU_COLORS;
  
  float r=min_color.r,g=min_color.g,b=min_color.b;
  int cont;
  
  for (cont=0;cont<SIMU_COLORS;cont++)
   {
     r+=mr;colors[cont].r=int(r);
     g+=mg;colors[cont].g=int(g);
     b+=mb;colors[cont].b=int(b);
     colors[cont].index=32+cont;
     colors[cont].pixel=fl_mapcolor(32+cont,int(r),int(g),int(b));
   }  
   
  mr=(max_color.r-zero_color.r)/(float)SIMU_COLORS;
  mg=(max_color.g-zero_color.g)/(float)SIMU_COLORS;
  mb=(max_color.b-zero_color.b)/(float)SIMU_COLORS;
  
  r=zero_color.r;
  g=zero_color.g;
  b=zero_color.b;
  
  for (cont=0;cont<SIMU_COLORS;cont++)
   {
     r+=mr;colors[SIMU_COLORS+cont].r=int(r);
     g+=mg;colors[SIMU_COLORS+cont].g=int(g);
     b+=mb;colors[SIMU_COLORS+cont].b=int(b);
     colors[SIMU_COLORS+cont].index=32+cont;
     colors[SIMU_COLORS+cont].pixel=fl_mapcolor(32+SIMU_COLORS+cont,int(r),int(g),int(b));
   }  
     
}


void simu_data::crea_color_map()
{
  color_map=(int *)malloc(nx*ny*sizeof(int)); 
}


void simu_data::crea_image()
{
  Display *disp=fl_get_display();
  int scr=DefaultScreen(disp);
  Visual *vis=DefaultVisual(disp,scr);
  
  int depth=fl_get_visual_depth();
  int bypp;
  
  sx=nx*zoom;
  sy=ny*zoom;
  
  switch(depth)
   {
     case  4: bypp=0;break;
     case  8: bypp=1;break;
     case 15: 
     case 16: bypp=2;break;
     case 24:
     case 32: bypp=4;break;
   }  

  image=XCreateImage(disp,vis,depth,ZPixmap,0,NULL,sx,sy,32,sx*bypp); 
  image->data=(char *)malloc(bypp*sx*sy);  
    
}


void simu_data::genera_image()
{
  int cx,cy,cont,color,pixel;
  
  
  for (cy=0;cy<DBoard.ny;cy++)
   for (cx=0;cx<DBoard.nx;cx++)
    {
      cont=DBoard.get_elem(cx,cy)-1;         
      
      if (cont>=0)
       {       
        switch(visu)
         {
          case POSITION_SIMU:
             color=int(scale_color*Simu_Onda.U[1][cont]);
             break;
          case VELOCITY_SIMU:
             color=int(scale_color*(Simu_Onda.U[1][cont]-Simu_Onda.U[0][cont])/Simu_Onda.get_time_step());       
             break;
         }         
         if (color>=SIMU_COLORS) color=SIMU_COLORS-1;
         if (color<=-SIMU_COLORS) color=-SIMU_COLORS;
         color+=SIMU_COLORS;
         pixel=colors[color].pixel;
       }
      else 
       {
         pixel=0;   
         color=SIMU_COLORS;
       }  
      
      color_map[cy*nx+cx]=color;
                    
      switch (zoom)
       {
         case 1: XPutPixel(image,cx,cy,pixel);
                 break;
                    
         case 2: XPutPixel(image,cx*2,cy*2,pixel);
                 XPutPixel(image,cx*2+1,cy*2,pixel);
                 XPutPixel(image,cx*2,cy*2+1,pixel);
                 XPutPixel(image,cx*2+1,cy*2+1,pixel);
                 break;
                 
         case 3:
         case 4:
         case 5:
         case 6:
         case 7:
         case 8:
                {
                  int bx,by;                 
                  for(by=0;by<zoom;by++)
                   for (bx=0;bx<zoom;bx++) XPutPixel(image,cx*zoom+bx,cy*zoom+by,pixel);
                }
                break;                                     
                  
       }          
                             
    } 
}



void simu_data::draw_image()
{ 
  GC gc=fl_state[fl_get_vclass()].gc[0];
  Window win=FL_ObjWin(fd_Simulation->Simu_Board);
  Display *disp=fl_get_display();
    
  XPutImage(disp,win,gc,image,0,0,image_x,image_y,sx,sy);
  
 // int cx,cy;   
 // for (cy=0;cy<sy;cy++)
 //  for (cx=0;cx<sx;cx++) XPutPixel(image,cx,cy,colors[int(0.7*cy)].pixel);        
   
  
 /*
   XPoint xp[4]; 
   
  xp[0].x=100;xp[0].y=100;
  xp[1].x=170;xp[1].y=170;
  xp[2].x=100;xp[2].y=170;
  xp[3].x=100;xp[3].y=100;
  
  
  //XSetForeground(disp,gc,16);
  //XDrawLines(disp,win,gc,xp,4,CoordModeOrigin);
  //XFillRectangle(disp,win,gc,mx,my,10,10);
 */ 

}


void simu_data::cambia_zoom(int a)
{

  if (a==zoom) return;
  zoom=a;
  
  destroy_image();
  crea_image();
  genera_image();
  fl_redraw_object(fd_Simulation->Simu_Board);
  
}




void simu_data::show_info()
{
  char label[32];
  float f=Simu_Onda.get_cuant_size();
  int cont=DBoard.get_elem(mouse_x,mouse_y)-1;

  sprintf(label,"QX: %d",mouse_x); 
  fl_set_object_label(fd_Simulation->Box_PosX,label); 
  sprintf(label,"QY: %d",mouse_y); 
  fl_set_object_label(fd_Simulation->Box_PosY,label);
  sprintf(label,"Step: %d",Simu_Data.steps); 
  fl_set_object_label(fd_Simulation->Box_Step,label);
 
  sprintf(label,"RX: %.5e",f*mouse_x); 
  fl_set_object_label(fd_Simulation->Box_RealX,label); 
  sprintf(label,"RY: %.5e",f*mouse_y); 
  fl_set_object_label(fd_Simulation->Box_RealY,label);
  sprintf(label,"Time: %f",steps*Simu_Onda.get_time_step()); 
  fl_set_object_label(fd_Simulation->Box_Time,label);
 
 
  if (cont<0) sprintf(label,"Fix Point");
  else
   {
    switch(visu)
     {
       case POSITION_SIMU: 
          sprintf(label,"Pos= %.4e",Simu_Onda.U[1][cont]); 
          break;
       case VELOCITY_SIMU:
          sprintf(label,"Vel= %.4e",(Simu_Onda.U[1][cont]-Simu_Onda.U[0][cont])/Simu_Onda.get_time_step());       
          break;
     }            
   }
     
  fl_set_object_label(fd_Simulation->Box_Value,label);                     
            
}


void simu_data::actualiza()
{
  genera_image();
  draw_image();
  show_info(); 
}  



void simu_data::save(FILE *f)
{

  fwrite(this,120,1,f);
  
}


void simu_data::load(FILE *f)
{
  fread(this,120,1,f);
  set_colors();
}


//*******************************************************************************


void main_data::set_defaults()
{
  draw_tool=POINT_TOOL;
  fix_color=22;
  free_color=18;

}


void main_data::draw_point()
{

}

void main_data::draw_line()
{

}

void main_data::draw_rect()
{

}

void main_data::draw_ellip()
{

}

void main_data::fill()
{ 
  
}


void main_data::save(FILE *f)
{
  fwrite(this,12,1,f);
}


void main_data::load(FILE *f)
{
  fread(this,12,1,f);
  fl_redraw_object(fd_Main->Design_Board);   
}


//*******************************************************************************

void render_data::set_defaults()
{
  set_mode(WIRE_RENDER);
  zoom=2;
  hscale=0.2;
  rx=140;
  ry=rz=0;
}

 
void render_data::set_zoom(GLfloat z)
{
  zoom=z;
  dx=zoom*Simu_Onda.get_cuant_size();
  dy=zoom*Simu_Onda.get_cuant_size();
  
  lx=(nx*dx)/2;
  ly=(ny*dy)/2;
  
  draw_malla(); 
}

 
void render_data::set_mode(int m)
{  
  switch(m)
   {
     case WIRE_RENDER:   primit=GL_LINE_LOOP;break;
     case FLAT_RENDER:   primit=GL_QUADS;break;
     case GORAUD_RENDER: primit=GL_QUADS;break;
   }  
    
  if (m==mode) return;
  mode=m;
  
  actualiza_render_mode();
 
  draw_malla(); 
}

void render_data::set_hscale(GLfloat hs)
{
  hscale=hs;
  genera_malla();
  draw_malla();
}  

 
void render_data::crea_malla()
{    
  nx=DBoard.get_nx();
  ny=DBoard.get_ny();
  
  set_zoom(zoom);
  
  malla=(GLfloat *)malloc(nx*ny*sizeof(GLfloat));
  if (malla==NULL) ;                              // Control de error.
    
}


void render_data::destroy_malla()
{ 
  free(malla);
}


void render_data::init_render()
{
    GLfloat light_ambient[] = { 0.0, 0.0, 0.0, 1.0 };
    GLfloat light_diffuse[] = { 0.0, 0.7, 0.7, 1.0 };
    GLfloat light_specular[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat light_position[] = { 2.0, 0.0, 3.0, 1.0 };    
//    GLfloat lm_ambient[] = { 0.1, 0.1, 0.1, 1.0 };

    glMaterialfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, light_diffuse);
    glMaterialfv(GL_LIGHT0, GL_SPECULAR, light_specular);
    glLightfv(GL_LIGHT0, GL_POSITION, light_position);
//    glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lm_ambient);


    actualiza_render_mode();
}



void render_data::actualiza_render_mode()
{
 
    switch (mode)
     {
       case WIRE_RENDER:
                          glDisable(GL_LIGHTING);
                          glDisable(GL_LIGHT0);
                          glDisable(GL_DEPTH_TEST);
                          break;
                          
       case FLAT_RENDER: 
                          glEnable(GL_LIGHTING);
                          glEnable(GL_LIGHT0);
                          glDepthFunc(GL_LESS);
                          glEnable(GL_DEPTH_TEST);
                          glShadeModel( GL_FLAT );
                          break;
                          
       case GORAUD_RENDER:
                          glEnable(GL_LIGHTING);
                          glEnable(GL_LIGHT0);
                          glDepthFunc(GL_LESS);
                          glEnable(GL_DEPTH_TEST);
                          glShadeModel( GL_SMOOTH );
                          break;
       
     }                           
        
}


 
void render_data::genera_malla()
{

  if (Render_Show==FALSE) return;   
  
  int cx,cy,n;
  GLfloat x,y,d=-hscale*zoom;
     
  for (y=-ly,cy=0;cy<ny;cy++,y+=dy)
   for (x=-lx,cx=0;cx<nx;cx++,x+=dx)
    {
      //d=sqrt(x*x+y*y);    
      //malla[cy*nx+cx]=hscale*0.1*sin(4*d+0.2*Simu_Data.steps);    
      
      n=DBoard.get_elem(cx,cy)-1;
      if (n>=0)
       {
         malla[cy*nx+cx]=d*Simu_Onda.U[1][n];
       }
      else malla[cy*nx+cx]=0;
                           
    }       

}


void render_data::draw_malla()
{
    
   if (Render_Show==FALSE) return;

   int cx,cy,p,color;
   GLfloat col,x=0,y=0,d=zoom*hscale;  

      
   fl_activate_glcanvas(fd_Render->Render_Board);
    
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   glPushMatrix();
  
   glRotatef( rx, 1.0, 0.0, 0.0 );  
   glRotatef( ry, 0.0, 1.0, 0.0 ); 
   glRotatef( rz, 0.0, 0.0, 1.0 );
//   glTranslatef(0.0,0.0,-1.5); 
  
   p=0;
   for(y=-ly,cy=0;cy<ny-1;cy++,y+=dy)
    for(x=-lx,cx=0;cx<nx-1;cx++,x+=dx)
     { 
      p=cy*nx+cx; 

      if (mode==WIRE_RENDER)
       {      
        color=Simu_Data.color_map[p];         
        glColor3ub(Simu_Data.colors[color].r,Simu_Data.colors[color].g,Simu_Data.colors[color].b);        
       } 
                            
      glBegin( primit );        
      v3f( x, y, malla[p]);
      v3f( x, y+dy, malla[p+nx]);       
      v3f( x+dx, y+dy,malla[p+nx+1]);
      v3f( x+dx, y, malla[p+1]);
      glEnd();
     }  
    
    glPopMatrix();

    glFinish();
    glXSwapBuffers(fl_display, fl_get_canvas_id(fd_Render->Render_Board));

//    glFlush;

}



//********************************************************************************


void WSM_Set_Defaults()
{

  Show_Param(FALSE);
  Show_Geom(FALSE);
  Show_Simu(FALSE);

  DBoard.crea(35,35);
  
  Simu_Onda.set_toles(7,0.00001,0.01);            // MAX_ITE,GS_TOL,K_TOL
  Simu_Onda.set_param(0,1,1,0.05,0.0085);         // mu,ro,h0=h,k0
  
  
  Simu_Data.set_defaults();
  Main_Data.set_defaults();
  Render_Data.set_defaults();
  
  Noname_File=TRUE;
  File_Modif=FALSE;  
  strcpy(nombre_archivo,"noname.wsm");
}


int WSM_Warning_Destroy()   // Devuelve 0 si se cancela.
{
  int opc;
  
  if (File_Modif==FALSE) return 1;
  
  opc=fl_show_choices("The file has been modified. Save the changes?",
                       3,"Yes","No","Cancel",1);               
                       
  if (opc==1)
   {
     WSM_Save();  
   }                        
                       
  if (opc!=3) return 1;
  return 0;
}  


int WSM_Save()
{

  char cid[4]="WSM";
  int cont;
  FILE *f=fopen(ruta_archivo,"wb");
  if (f==NULL) return 1;
  
  // Cabecera:
  fwrite(cid,4,1,f);                            // Escribir ID
  for (cont=0;cont<26;cont++) fputc(0,f);       // Escribir 26 0's
  
  DBoard.save(f);
  Simu_Onda.save(f);
  
  Main_Data.save(f);
  Simu_Data.save(f);
  
  File_Modif=FALSE;
  Noname_File=FALSE;
  
  fclose(f);
  return 0;
}    
  
  
int WSM_Load()
{

  char cid[4]="WSM";
  int cont;
  FILE *f=fopen(ruta_archivo,"rb");
  if (f==NULL) return 1;
  
  // Cabecera:
  fread(cid,4,1,f);                            // Leer ID  
  if (strcmp(cid,"WSM")!=0) return 2;
  
  for (cont=0;cont<26;cont++) fgetc(f);        // Leer 26 0's
  
  Show_Simu(FALSE);
  Show_Param(FALSE);
  Show_Geom(FALSE);
  
  DBoard.load(f);
  Simu_Onda.load(f);
  
  Main_Data.load(f);
  Simu_Data.load(f);  
  
  fclose(f);
    
  Noname_File=FALSE;
  File_Modif=FALSE;  
  
  return 0;
}


//********************************************************************************


void Kick_Simu(int px,int py,int p)
{  
  int acum=0;
  int x,y,l=Simu_Data.thickness;
  int r2=l*l;
  
  float d2,z=p*Simu_Data.level;
  if (Simu_Data.visu==VELOCITY_SIMU) z*=Simu_Onda.get_time_step();

  for (y=-l;y<=l;y++)
   for(x=-l;x<=l;x++)
    {  
      d2=x*x+y*y;
      if (d2<=r2) acum+=Add_Elem_Simu(px+x,py+y,z*(1-(float)d2/r2));                  
    }   
             
  if (acum==0) return;
             
  Simu_Data.actualiza();
  if (Render_Show==TRUE) Render_Data.actualiza();

}


int Add_Elem_Simu(int px,int py,float z)
{
   if (px<0||py<0||px>=DBoard.get_nx()||py>=DBoard.get_ny()) return FALSE;
   
   int elem=DBoard.get_elem(px,py)-1;
   if (elem<0) return FALSE;
      
   switch(Simu_Data.visu)
     {
       case POSITION_SIMU:                                                  
              Simu_Onda.U[0][elem]+=z;
              Simu_Onda.U[1][elem]+=z;
              break;
       case VELOCITY_SIMU:
              Simu_Onda.U[1][elem]+=z;  
              break;       
      }               
    
   return TRUE; 
}

                                               
//********************************************************************************

void Play_Simu()
{
  if (Simu_Play==FALSE)
   {
     Simu_Play=TRUE;
     set_play_button(FALSE);
//     fl_set_pixmapbutton_data(fd_Simulation->Control_Bot[PLAY_SIMU],simu_stop_xpm);      
     
     Simu_Timeout_ID=fl_add_timeout(SIMU_FRAME_TIME,CB_Simu_Timeout,NULL);       
   } 
}


void Stop_Simu()
{
 if (Simu_Play==TRUE)
  {
    Simu_Play=FALSE;
    fl_remove_timeout(Simu_Timeout_ID);
    set_play_button(TRUE);
//    fl_set_pixmapbutton_data(fd_Simulation->Control_Bot[PLAY_SIMU],simu_play_xpm); 
    fl_set_button(fd_Simulation->Control_Bot[PLAY_SIMU],FALSE);        
  }
}




//********************************************************************************

void Show_Main(int t)
{
  switch(t)
   {
    case TRUE:
        if (Main_Show==FALSE)
         {
           fl_set_form_minsize(fd_Main->Main,MAIN_MINSIZE_X,MAIN_MINSIZE_Y);
           fl_show_form(fd_Main->Main,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"WaveSim V1.0");
           Main_Show=TRUE;  
         }
        break;

    case FALSE:        
         if (Main_Show==TRUE)
         {
           fl_hide_form(fd_Main->Main);
           Main_Show=FALSE;  
         }
        break;
    }

}



void Show_Param(int t)
{
  switch(t)
   {
    case TRUE:
        if (Param_Show==FALSE)
         {
           Set_Param();
           fl_show_form(fd_Parameters->Parameters,FL_PLACE_CENTER,FL_FULLBORDER,"Parameters");
           Param_Show=TRUE;  
         }
        break;

    case FALSE:        
         if (Param_Show==TRUE)
         {
           fl_hide_form(fd_Parameters->Parameters);
           Param_Show=FALSE;  
         }
        break;
    }
}



void Show_Geom(int t)
{
  switch(t)
   {
    case TRUE:
        if (Geom_Show==FALSE)
         {
           Set_Geom();
           fl_show_form(fd_Geometry->Geometry,FL_PLACE_CENTER,FL_FULLBORDER,"Geometry");
           Geom_Show=TRUE;  
         }
        break;

    case FALSE:        
         if (Geom_Show==TRUE)
         {
           fl_hide_form(fd_Geometry->Geometry);
           Geom_Show=FALSE;  
         }
        break;
    }

}

void Show_Simu(int t)
{
  switch(t)
   {
    case TRUE:
        if (Simu_Show==FALSE)
         {
           Simu_Onda.crea(DBoard.set_order());
           Simu_Onda.calcula_M(DBoard);
           Simu_Data.crea();
           Simu_Data.genera_image();
           Simu_Data.steps=0;
           Simu_Data.show_info();
        
           Set_Simu();
           fl_set_form_minsize(fd_Simulation->Simulation,SIMU_MINSIZE_X,SIMU_MINSIZE_Y);
           fl_show_form(fd_Simulation->Simulation,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"Simulation");           
           Simu_Show=TRUE;
                 
           fl_deactivate_object(fd_Main->Design_Board);
           fl_deactivate_object(fd_Main->Tool_Bot[CLEAR_TOOL]);
//           fl_deactivate_object(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
//           fl_deactivate_object(fd_Geometry->Scroll[CUANTIZEY_GEOM]);  
         }
        break;

    case FALSE:        
         if (Simu_Show==TRUE)
         {           
           Stop_Simu();
           Show_Render(FALSE);
           fl_hide_form(fd_Simulation->Simulation);
           Simu_Data.destroy();
           Simu_Onda.destruye();
           Simu_Show=FALSE;  
             
           fl_activate_object(fd_Main->Design_Board);
           fl_activate_object(fd_Main->Tool_Bot[CLEAR_TOOL]);
//           fl_activate_object(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
//           fl_activate_object(fd_Geometry->Scroll[CUANTIZEY_GEOM]);  
         }
        break;
    }
}


void Show_Render(int t)
{

 switch(t)
   {
    case TRUE:
        if (Render_Show==FALSE)
         {
           Render_Data.crea_malla();
           Render_Data.init_render();

           Render_Show=TRUE;  
           Render_Data.genera_malla();

           Set_Render();
           fl_set_form_minsize(fd_Render->Render,RENDER_MINSIZE_X,RENDER_MINSIZE_Y);
           fl_show_form(fd_Render->Render,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"Render");

         }
        break;

    case FALSE:        
         if (Render_Show==TRUE)
         {
           Render_Data.destroy_malla();
           fl_hide_form(fd_Render->Render);
           Render_Show=FALSE;  
         }
        break;
    }

}

void Show_Wave(int t)
{

//   fl_show_messages("This Feature is unimplemented by now.");

 switch(t)
   {
    case TRUE:
        if (Wave_Show==FALSE)
         {

           Wave_Show=TRUE;          

           Set_Wave();
           //fl_set_form_minsize(fd_Wave->Wave,WAVE_MINSIZE_X,WAVE_MINSIZE_Y);
           fl_show_form(fd_Wave->Wave,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"Wave");
         }
        break;

    case FALSE:        
         if (Wave_Show==TRUE)
         {
           fl_hide_form(fd_Wave->Wave);
           Wave_Show=FALSE;  
         }
        break;
    }

}


//*************************************************************************


void descomp_value(float *v,int *sc)
{
 
  float d=100;
  (*sc)=0;
  
  if ((*v)==0)
   {
     *sc=2;
     return;
   }  
  
  for (d=100;d>=1e-9;d/=10)
   { 
      if ((*v)>=d) 
       {      
         (*v)/=d;
         return;
       }  
      (*sc)++;      
   }
      
}



void Apply_Param()
{
  float dead,dens,tens,step,gstol;
  float sc;
  int gsmax,choice;
  
  
  choice=fl_get_choice(fd_Parameters->Scale[DENSITY_PARAM]);
  sc=scale_value[choice-1];
  dens=sc*fl_get_slider_value(fd_Parameters->Scroll[DENSITY_PARAM]);
  
  choice=fl_get_choice(fd_Parameters->Scale[TENSION_PARAM]);
  sc=scale_value[choice-1];
  tens=sc*fl_get_slider_value(fd_Parameters->Scroll[TENSION_PARAM]);

  choice=fl_get_choice(fd_Parameters->Scale[DEADEN_PARAM]);
  sc=scale_value[choice-1];
  dead=sc*fl_get_slider_value(fd_Parameters->Scroll[DEADEN_PARAM]);
  
  choice=fl_get_choice(fd_Parameters->Scale[STEP_PARAM]);
  sc=scale_value[choice-1];
  step=sc*fl_get_slider_value(fd_Parameters->Scroll[STEP_PARAM]);
  
  choice=fl_get_choice(fd_Parameters->Scale[GSTOL_PARAM]);
  sc=scale_value[choice-1];
  gstol=sc*fl_get_slider_value(fd_Parameters->Scroll[GSTOL_PARAM]);
  
  gsmax=(int)fl_get_slider_value(fd_Parameters->Scroll[GSMAXITE_PARAM]);
  
  
  Simu_Onda.set_tension(tens);
  Simu_Onda.set_density(dens);
  Simu_Onda.set_deaden(dead);
  Simu_Onda.set_time_step(step);
  Simu_Onda.set_toles(gsmax,gstol);  
  
  Simu_Onda.calcula_constants();
  
  if (Simu_Show==TRUE) Simu_Onda.calcula_M(DBoard);
  
  File_Modif=TRUE;
  
}


void Set_Param()
{
  float a;
  int sc;
  
  a=Simu_Onda.get_density();
  descomp_value(&a,&sc);
  fl_set_choice(fd_Parameters->Scale[DENSITY_PARAM],sc+1);
  fl_set_slider_value(fd_Parameters->Scroll[DENSITY_PARAM],a);
  
  
  a=Simu_Onda.get_tension();
  descomp_value(&a,&sc);
  fl_set_choice(fd_Parameters->Scale[TENSION_PARAM],sc+1);
  fl_set_slider_value(fd_Parameters->Scroll[TENSION_PARAM],a);
  
  a=Simu_Onda.get_deaden();
  descomp_value(&a,&sc);
  fl_set_choice(fd_Parameters->Scale[DEADEN_PARAM],sc+1);
  fl_set_slider_value(fd_Parameters->Scroll[DEADEN_PARAM],a);
  
  a=Simu_Onda.get_time_step();
  descomp_value(&a,&sc);
  fl_set_choice(fd_Parameters->Scale[STEP_PARAM],sc+1);
  fl_set_slider_value(fd_Parameters->Scroll[STEP_PARAM],a);
  
  a=Simu_Onda.get_GS_TOL();
  descomp_value(&a,&sc);
  fl_set_choice(fd_Parameters->Scale[GSTOL_PARAM],sc+1);
  fl_set_slider_value(fd_Parameters->Scroll[GSTOL_PARAM],a);
  
  a=Simu_Onda.get_GS_MAX();
  fl_set_slider_value(fd_Parameters->Scroll[GSMAXITE_PARAM],a);
      
}


void Apply_Geom()
{
  int choice,cx,cy;
  float csize,sc;

  choice=fl_get_choice(fd_Geometry->Scale[CUANTSIZE_GEOM]);
  sc=scale_value[choice-1];
  csize=sc*fl_get_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM]);
  
  cx=(int)fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
  cy=(int)fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEY_GEOM]);
  
  if ((cx!=DBoard.get_nx()) || (cy!=DBoard.get_ny()))
   {
      sc=fl_show_choices("This change will destroy the actual design. Continue?",
                          2,"Yes","No","",1);               
      if (sc==2) return;      
      else  
        {  
           Show_Simu(FALSE);
           DBoard.crea(cx,cy);                
           fl_redraw_object(fd_Main->Design_Board);
        }   
      
   }  
       
  Simu_Onda.set_cuant_size(csize);
  
  File_Modif=TRUE;
  
}


void Set_Geom()
{

  float cs,cx,cy,real;
  int sc;
  
  cs=Simu_Onda.get_cuant_size();
  descomp_value(&cs,&sc);
  fl_set_choice(fd_Geometry->Scale[CUANTSIZE_GEOM],sc+1);
  fl_set_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM],cs);
  
  cx=(float)DBoard.get_nx();
  fl_set_slider_value(fd_Geometry->Scroll[CUANTIZEX_GEOM],cx);
  
  cy=(float)DBoard.get_ny();
  fl_set_slider_value(fd_Geometry->Scroll[CUANTIZEY_GEOM],cy);


  real=cx*cs;
  descomp_value(&real,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEX_GEOM],real);
  fl_set_choice(fd_Geometry->Scale[REALSIZEX_GEOM],sc+1);  
  
  real=cy*cs;
  descomp_value(&real,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEY_GEOM],real);
  fl_set_choice(fd_Geometry->Scale[REALSIZEY_GEOM],sc+1);  
}


void Set_Simu()
{
  
  fl_set_slider_value(fd_Simulation->Scroll_ColorScale,Simu_Data.scale_color);
  fl_set_counter_value(fd_Simulation->Scroll_Zoom,Simu_Data.zoom);
  fl_set_counter_value(fd_Simulation->Scroll_Level,Simu_Data.level);
  fl_set_counter_value(fd_Simulation->Scroll_Thickness,Simu_Data.thickness);
    
  fl_set_button(fd_Simulation->Solution_Bot[Simu_Data.visu],1);

  fl_set_counter_value(fd_Simulation->R_Scroll[SIMU_COLMIN],Simu_Data.min_color.r);
  fl_set_counter_value(fd_Simulation->G_Scroll[SIMU_COLMIN],Simu_Data.min_color.g);
  fl_set_counter_value(fd_Simulation->B_Scroll[SIMU_COLMIN],Simu_Data.min_color.b);
  
  fl_set_counter_value(fd_Simulation->R_Scroll[SIMU_COLZERO],Simu_Data.zero_color.r);
  fl_set_counter_value(fd_Simulation->G_Scroll[SIMU_COLZERO],Simu_Data.zero_color.g);
  fl_set_counter_value(fd_Simulation->B_Scroll[SIMU_COLZERO],Simu_Data.zero_color.b);

  fl_set_counter_value(fd_Simulation->R_Scroll[SIMU_COLMAX],Simu_Data.max_color.r);
  fl_set_counter_value(fd_Simulation->G_Scroll[SIMU_COLMAX],Simu_Data.max_color.g);
  fl_set_counter_value(fd_Simulation->B_Scroll[SIMU_COLMAX],Simu_Data.max_color.b);
  
  Simu_Data.show_info();


}



void Set_Render()
{

  fl_set_positioner_xvalue(fd_Render->RXRY_Posit,Render_Data.ry);
  fl_set_positioner_yvalue(fd_Render->RXRY_Posit,Render_Data.rx);
  fl_set_slider_value(fd_Render->RotZ_Scroll,Render_Data.rz);
  
  fl_set_slider_value(fd_Render->Zoom_Scroll,Render_Data.zoom);
  fl_set_slider_value(fd_Render->HScale_Scroll,Render_Data.hscale);

  fl_set_button(fd_Render->Mode_Bot[Render_Data.mode],TRUE);

}


void Set_Wave()
{


}

//***********************************************************************
