		
#include "forms.h"
#include "wavesim.h"

#include "wavesim_func.h"

//***************************************************************************

/****************************************************************************/
/******************* callbacks for form Parameters **************************/


void CB_Param_Apply(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  if (Param_Modif==TRUE)
   {   
     Apply_Param();     
     Param_Modif=FALSE;
   }   
}

void CB_Param_Close(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  if (data==OK_BOT) CB_Param_Apply(ob,APPLY_BOT);  
  Show_Param(FALSE);  
}

void CB_Param_Density(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */  
  Param_Modif=TRUE;
}

void CB_Param_Tension(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Param_Modif=TRUE;
}

void CB_Param_Step(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Param_Modif=TRUE;
}

void CB_Param_GSTol(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Param_Modif=TRUE;
}

void CB_Param_GSMaxIte(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Param_Modif=TRUE;
}

void CB_Param_Deaden(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Param_Modif=TRUE;
}


/********************************************************/
/************ callbacks for form Main *******************/


void CB_Menu_File(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  char *cad="noname.wsm";
  int select=fl_get_menu(ob);
  int opc;
  
  switch(select-1)
   {
     case MFILE_NEW:
          if (WSM_Warning_Destroy()==1)
           {
            WSM_Set_Defaults();          
            fl_redraw_object(fd_Main->Design_Board);
           } 
          break;
     
     case MFILE_LOAD_BM:
     case MFILE_SAVE_BM:            
          fl_show_messages("This Feature is unimplemented by now.");
          break;
     
     case MFILE_LOAD:
          if (WSM_Warning_Destroy()==1)
           {
            cad=(char *)fl_show_fselector("Archivo:",nombre_directory,"*.wsm",nombre_archivo);
            if (cad!=NULL)
             {
               strcpy(ruta_archivo,cad);
               cad=(char *)fl_get_filename();
               strcpy(nombre_archivo,cad);
               cad=(char *)fl_get_directory();
               strcpy(nombre_directory,cad);
               WSM_Load();               
             }  
           } 
          break;
          
     case MFILE_SAVE:
          if (Noname_File==FALSE)
           { 
             WSM_Save(); 
             break;
           }            
          
     case MFILE_SAVEAS: 
          cad=(char *)fl_show_fselector("Archivo :",nombre_directory,"*.wsm",nombre_archivo); 
          if (cad!=NULL)
           {           
             strcpy(ruta_archivo,cad);
             cad=(char *)fl_get_filename();
             strcpy(nombre_archivo,cad);
             cad=(char *)fl_get_directory();
             strcpy(nombre_directory,cad);
             WSM_Save();           
           } 
          break;
     
     case MFILE_QUIT:
          if (WSM_Warning_Destroy()==1) exit(0);                       
          break;
      
   }    
}


void CB_Menu_View(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */

  int select=fl_get_menu(ob);
  
  switch(select-1)
   {
     case MVIEW_PARAMETERS:
          Show_Param(TRUE);
          break;
     case MVIEW_SIMULATION:
          Show_Simu(TRUE);
          break;           
     case MVIEW_GEOMETRY:
          Show_Geom(TRUE);
          break;    
     case MVIEW_RENDER:
          Show_Render(TRUE);
          break;    
     case MVIEW_WAVE:
          Show_Wave(TRUE);
          break;     
   }  
}


void CB_Menu_Help(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  int select=fl_get_menu(ob);
  
  
  switch(select-1)
   {
     case MHELP_OVERVIEW: 
          if (Help_Show==1) CB_Help_Close(fd_Help->Help_Browser,0);
          fl_load_browser(fd_Help->Help_Browser,"overview.txt");
          fl_show_form(fd_Help->Help,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"WaveSim Help: OverView");
          Help_Show=1;
          break;
          
     case MHELP_INSTRUCTION: 
          if (Help_Show==1) CB_Help_Close(fd_Help->Help_Browser,0);
          fl_load_browser(fd_Help->Help_Browser,"instruction.txt");
          fl_show_form(fd_Help->Help,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"WaveSim Help: Instruction");
          Help_Show=1;
          break;

     case MHELP_ABOUT:
          fl_show_form(fd_About->About,FL_PLACE_CENTER,FL_FULLBORDER,"About WaveSim ...");
          break;
   }  
}


void CB_Fast_Bar(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  switch (data)
   {
     case PARAM_DLG:    
          Show_Param(TRUE);
          break;       
     case SIMU_DLG:
          Show_Simu(TRUE);
          break;           
     case GEOM_DLG:
          Show_Geom(TRUE);
          break;
     case RENDER_DLG:
          Show_Render(TRUE);
          break;
     case WAVE_DLG:
          Show_Wave(TRUE);
          break;
   }       
}


void CB_Tool_Bot(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  switch(data)
   { 
    case POINT_TOOL:
    case LINE_TOOL:
    case RECT_TOOL:
    case FILLRECT_TOOL:
    case ELLIP_TOOL:
    case FILLELLIP_TOOL:
    case FILL_TOOL: Main_Data.draw_tool=data;break;
    
    case CLEAR_TOOL:
                    DBoard.clear();
                    fl_redraw_object(fd_Main->Design_Board);
                    break;
    
    case GEOM_TOOL: 
                    Show_Geom(TRUE);
                    break;
   
   }
}



/*********************************************************************************/
/********************** callbacks for form Geometry ******************************/


void CB_Geom_CuantizeX(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  int sc=fl_get_choice(fd_Geometry->Scale[CUANTSIZE_GEOM]);
  float size=fl_get_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM]);
  float nx=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
  float realx=nx*size*scale_value[sc-1];
  descomp_value(&realx,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEX_GEOM],realx);
  fl_set_choice(fd_Geometry->Scale[REALSIZEX_GEOM],sc+1);  
  
  
  Geom_Modif=TRUE;
}

void CB_Geom_CuantizeY(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
      
  int sc=fl_get_choice(fd_Geometry->Scale[CUANTSIZE_GEOM]);
  float size=fl_get_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM]);
  float ny=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEY_GEOM]);
  float realy=ny*size*scale_value[sc-1];
  descomp_value(&realy,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEY_GEOM],realy);
  fl_set_choice(fd_Geometry->Scale[REALSIZEY_GEOM],sc+1);  

  
  Geom_Modif=TRUE;
}

void CB_Geom_RealSizeX(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  int sc=fl_get_choice(fd_Geometry->Scale[REALSIZEX_GEOM]);
  float realx=scale_value[sc-1]*fl_get_slider_value(fd_Geometry->Scroll[REALSIZEX_GEOM]);
  float nx=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
  float size=realx/nx;
  float siz=size;
  descomp_value(&siz,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM],siz);
  fl_set_choice(fd_Geometry->Scale[CUANTSIZE_GEOM],sc+1);  
  
  float ny=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEY_GEOM]);
  float realy=size*ny;
  descomp_value(&realy,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEY_GEOM],realy);
  fl_set_choice(fd_Geometry->Scale[REALSIZEY_GEOM],sc+1);  

  Geom_Modif=TRUE;
}

void CB_Geom_RealSizeY(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  int sc=fl_get_choice(fd_Geometry->Scale[REALSIZEY_GEOM]);
  float realy=scale_value[sc-1]*fl_get_slider_value(fd_Geometry->Scroll[REALSIZEY_GEOM]);
  int ny=(int)fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEY_GEOM]);
  float size=realy/ny;
  float siz=size;
  descomp_value(&siz,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM],siz);
  fl_set_choice(fd_Geometry->Scale[CUANTSIZE_GEOM],sc+1);  
  
  float nx=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
  float realx=size*nx;
  descomp_value(&realx,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEX_GEOM],realx);
  fl_set_choice(fd_Geometry->Scale[REALSIZEX_GEOM],sc+1);  

  
  Geom_Modif=TRUE;
}


void CB_Geom_CuantSize(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  int sc=fl_get_choice(fd_Geometry->Scale[CUANTSIZE_GEOM]);
  float size=scale_value[sc-1]*fl_get_slider_value(fd_Geometry->Scroll[CUANTSIZE_GEOM]);  
  
  float n=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEX_GEOM]);
  float real=n*size;
  descomp_value(&real,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEX_GEOM],real);
  fl_set_choice(fd_Geometry->Scale[REALSIZEX_GEOM],sc+1);  
  
  n=fl_get_slider_value(fd_Geometry->Scroll[CUANTIZEY_GEOM]);
  real=n*size;
  descomp_value(&real,&sc);
  fl_set_slider_value(fd_Geometry->Scroll[REALSIZEY_GEOM],real);
  fl_set_choice(fd_Geometry->Scale[REALSIZEY_GEOM],sc+1);  
  
  Geom_Modif=TRUE;
}


void CB_Geom_Apply(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  if (Geom_Modif==1)
   {
     Apply_Geom();
          
     Geom_Modif=FALSE;
   }  
}

void CB_Geom_Close(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  if (data==OK_BOT) CB_Geom_Apply(ob,APPLY_BOT);
  
  Show_Geom(FALSE);
}



/********************************************************************************/
/********************** callbacks for form Simulation ***************************/



void CB_Simu_Play(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */

  if (Simu_Play==0) Play_Simu();
  else Stop_Simu();
     
}

void CB_Simu_Step(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  int cont=Simu_Data.skip;
  
  Stop_Simu();  
  
  do
   {
     Simu_Onda.itera_U();
     cont--;
   } while (cont>=0);     
  
  Simu_Data.steps+=Simu_Data.skip+1;  
  Simu_Data.actualiza();  
  if (Render_Show==TRUE) Render_Data.actualiza();
}


void CB_Simu_Timeout(int id,void *data)
{
  int cont=Simu_Data.skip;
  
  do
   {
     Simu_Onda.itera_U();
     cont--;
   } while (cont>=0);     
  
  Simu_Data.steps+=Simu_Data.skip+1;  
  Simu_Data.actualiza();
  if (Render_Show==TRUE) Render_Data.actualiza();
  if (Simu_Play==1) Simu_Timeout_ID=fl_add_timeout(SIMU_FRAME_TIME,CB_Simu_Timeout,NULL);
}


void CB_Simu_Restart(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Stop_Simu();
  Simu_Onda.reset();
  Simu_Data.steps=0;
  Simu_Data.actualiza();
  Render_Data.actualiza();  
}


void CB_Simu_Thickness(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  Simu_Data.thickness=(int)fl_get_counter_value(ob);
  
  File_Modif=TRUE;
}

void CB_Simu_Level(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  Simu_Data.level=fl_get_counter_value(ob);
  
  File_Modif=TRUE;
}

void CB_Simu_Solution(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  Simu_Data.visu=data;
  Simu_Data.actualiza();
  
  File_Modif=TRUE;    
}


void CB_Simu_ColorScale(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  Simu_Data.scale_color=fl_get_slider_value(ob);
  Simu_Data.genera_image();
  Simu_Data.draw_image();
  
  File_Modif=TRUE;
}


void CB_Simu_ColMin(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  
  Simu_Data.min_color.r=(int)fl_get_counter_value(fd_Simulation->R_Scroll[SIMU_COLMIN]); 
  Simu_Data.min_color.g=(int)fl_get_counter_value(fd_Simulation->G_Scroll[SIMU_COLMIN]);
  Simu_Data.min_color.b=(int)fl_get_counter_value(fd_Simulation->B_Scroll[SIMU_COLMIN]);
  
  Simu_Data.min_color.pixel=fl_mapcolor(Simu_Data.min_color.index,Simu_Data.min_color.r,
                                        Simu_Data.min_color.g,Simu_Data.min_color.b);
  Simu_Data.set_colors();
  fl_redraw_object(fd_Simulation->Muestra_Col[SIMU_COLMIN]);
  Simu_Data.genera_image();  
  Simu_Data.draw_image();
  
  File_Modif=TRUE;  

}


void CB_Simu_ColZero(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  Simu_Data.zero_color.r=(int)fl_get_counter_value(fd_Simulation->R_Scroll[SIMU_COLZERO]); 
  Simu_Data.zero_color.g=(int)fl_get_counter_value(fd_Simulation->G_Scroll[SIMU_COLZERO]);
  Simu_Data.zero_color.b=(int)fl_get_counter_value(fd_Simulation->B_Scroll[SIMU_COLZERO]);
  
  Simu_Data.min_color.pixel=fl_mapcolor(Simu_Data.zero_color.index,Simu_Data.zero_color.r,
                                        Simu_Data.zero_color.g,Simu_Data.zero_color.b);
  Simu_Data.set_colors();
  fl_redraw_object(fd_Simulation->Muestra_Col[SIMU_COLZERO]);
  Simu_Data.genera_image();
  Simu_Data.draw_image();
  
  File_Modif=TRUE; 
  
}

void CB_Simu_ColMax(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  Simu_Data.max_color.r=(int)fl_get_counter_value(fd_Simulation->R_Scroll[SIMU_COLMAX]); 
  Simu_Data.max_color.g=(int)fl_get_counter_value(fd_Simulation->G_Scroll[SIMU_COLMAX]);
  Simu_Data.max_color.b=(int)fl_get_counter_value(fd_Simulation->B_Scroll[SIMU_COLMAX]);
  
  Simu_Data.min_color.pixel=fl_mapcolor(Simu_Data.max_color.index,Simu_Data.max_color.r,
                                        Simu_Data.max_color.g,Simu_Data.max_color.b);
  Simu_Data.set_colors();
  fl_redraw_object(fd_Simulation->Muestra_Col[SIMU_COLMAX]);
  Simu_Data.genera_image();
  Simu_Data.draw_image();

  File_Modif=TRUE;  

}


void CB_Simu_Zoom(FL_OBJECT *ob, long data)
{
 /* fill-in code for callback */
 
 Simu_Data.cambia_zoom((int)fl_get_counter_value(ob));
 
  File_Modif=TRUE; 
 
}



void CB_Simu_Skip(FL_OBJECT *ob, long data)
{
 /* fill-in code for callback */
 
 Simu_Data.skip=(int)fl_get_counter_value(ob);
 
 File_Modif=TRUE; 
 
}


void CB_Simu_WaveDlg(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Show_Wave(TRUE);
  
}


void CB_Simu_RenderDlg(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  Show_Render(TRUE);
}


void CB_Simu_Close(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */  
  Show_Simu(FALSE);
}



/***************** callbacks for form Help *****************/


void CB_Help_Close(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
    
  fl_hide_form(ob->form);
  fl_clear_browser(fd_Help->Help_Browser);
  Help_Show=0;
}


/***************** callbacks for form About ****************/

void CB_About_Close(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  
  fl_hide_form(ob->form);
}



/***************** callbacks for form Render ****************/


void CB_Render_RXRY(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   Render_Data.ry=fl_get_positioner_xvalue(ob);
   Render_Data.rx=fl_get_positioner_yvalue(ob);
   Render_Data.draw_malla();
}


void CB_Render_RotZ(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */   
   
   Render_Data.rz=fl_get_slider_value(ob);
   Render_Data.draw_malla();
}   

void CB_Render_Close(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
   Show_Render(FALSE);
}

void CB_Render_Mode(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
   Render_Data.set_mode(data);
}

void CB_Render_Zoom(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
   Render_Data.set_zoom(fl_get_slider_value(ob));
}


void CB_Render_HScale(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
   Render_Data.set_hscale(fl_get_slider_value(ob));
}



/***************** callbacks for form Wave ****************/


void CB_Wave_Freq(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
}


void CB_Wave_Restart(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
}

void CB_Wave_Play(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
}

void CB_Wave_Rec(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
}

void CB_Wave_Zoom(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
}


void CB_Wave_Close(FL_OBJECT *ob, long data)
{
   /* fill-in code for callback */
   
   Show_Wave(FALSE);
      
}


//***********************************************************
//***********************************************************

int Design_Board_Handle(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev)
{
 int nx=DBoard.get_nx(),ny=DBoard.get_ny(); 
 int sx=obj->w/nx;
 int sy=obj->h/ny;
 int px=(mx-obj->x)/sx,py=(my-obj->y)/sy;
 int static color=0;
  
 switch(event)
  {
    case FL_DRAW: 
                {
                  int cx,cy; 
                  fl_drw_box(obj->boxtype,obj->x,obj->y,obj->w,obj->h,obj->col1,obj->bw);   
                  
                  for (cy=0;cy<ny;cy++)
                   for (cx=0;cx<nx;cx++)
                    {
                     if (DBoard.get_elem(cx,cy)!=0) fl_rectf(obj->x+cx*sx,obj->y+cy*sy,sx,sy,Main_Data.free_color);
                     else fl_rectf(obj->x+cx*sx,obj->y+cy*sy,sx,sy,Main_Data.fix_color);
                    } 
                  
                  break;
                }  
                
    case FL_MOUSE:                                 
                  if (px<nx&&py<ny&&px>=0&&py>=0)                  
                   {                                      
                    switch (Main_Data.draw_tool)
                     {
                       case POINT_TOOL:                                   
                                  fl_rectf(obj->x+px*sx,obj->y+py*sy,sx,sy,color); 
                                  if (color==Main_Data.free_color) DBoard.set_elem(px,py,1);
                                  else DBoard.set_elem(px,py,0);
                                  break;
                                      
                       case LINE_TOOL: Main_Data.draw_line();break;
                       case RECT_TOOL: Main_Data.draw_rect();break;
                       case FILLRECT_TOOL: break;
                       case ELLIP_TOOL: Main_Data.draw_ellip();break;
                       case FILLELLIP_TOOL: break;
                       case FILL_TOOL: break;
                     }  
                   }  
                  break;
                  
    case FL_PUSH: 
                  if (fl_mouse_button()==1) color=Main_Data.fix_color;
                  else color=Main_Data.free_color;                  
                  mx1=px;
                  my1=py;
                  drawing=TRUE;                                    
                  break;
    
    case FL_RELEASE:
                  drawing=FALSE;                  
                  File_Modif=TRUE;
                  switch (Main_Data.draw_tool)
                   {
                     case POINT_TOOL: break;
                     case LINE_TOOL: break;
                     case RECT_TOOL: break;
                     case FILLRECT_TOOL: break;
                     case ELLIP_TOOL: break;
                     case FILLELLIP_TOOL: break;
                     case FILL_TOOL: break;
                   }
                  break;       
    
    case FL_ENTER: fl_set_cursor(fd_Main->Main->window,XC_plus);break;
    case FL_LEAVE: fl_reset_cursor(fd_Main->Main->window);break;
    
    case FL_MOTION:                   
                   if (px>=0&&py>=0&&px<nx&&py<ny)
                    {
                      char cad[32];
                      sprintf(cad,"X=%d  Y=%d",px,py);
                      fl_set_object_label(fd_Main->Box_Pos,cad);  
                    }                        
                   break; 
    

  }  
  
 return 0; 
   
}




int Simu_Board_Handle(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev)
{ 
 int nx=DBoard.get_nx(),ny=DBoard.get_ny(); 
 int px=(mx-Simu_Data.image_x)/Simu_Data.zoom,py=(my-Simu_Data.image_y)/Simu_Data.zoom;
 

 int static p=1;

 switch(event)
  {
    case FL_DRAW:                      
                 {
                  int sx=DBoard.get_nx()*Simu_Data.zoom;
                  int sy=DBoard.get_ny()*Simu_Data.zoom;
                  Simu_Data.image_x=obj->x+(obj->w-sx)/2;
                  Simu_Data.image_y=obj->x+(obj->h-sy)/2;  
                  fl_drw_box(FL_FRAME_BOX,obj->x,obj->y,obj->w,obj->h,obj->col1,obj->bw);   
                  Simu_Data.draw_image();
                 } 
                break;
                  
    case FL_MOUSE:
                 if (px<nx&&py<ny&&px>=0&&py>=0)
                   {                                                                                                   
                     Kick_Simu(px,py,p);                                                                                                  } 
                 break;

    
    
    case FL_PUSH: if (fl_mouse_button()==1) p=1;
                  else p=-1;
                  break;
    
    case FL_RELEASE:break;
    
    case FL_ENTER: fl_set_cursor(FL_ObjWin(obj),XC_circle);break;
    case FL_LEAVE: fl_reset_cursor(FL_ObjWin(obj));break;
    
    case FL_MOTION:                   
                   if (px>=0&&py>=0&&px<nx&&py<ny)
                    {
                      if (Simu_Data.mouse_x!=px||Simu_Data.mouse_y!=py)
                       {
                         Simu_Data.set_mouse(px,py);                         
                         Simu_Data.show_info();  
                       }  
                    }                        
                   break; 
                  
  }
  
 return 0;                 
                   
}



int Render_Board_Expose(FL_OBJECT *ob, Window win, int w, int h, XEvent *xev, void *ud)
{

    glViewport(0,0, (GLint)w, (GLint)h);
    glClearColor(0.0,0.0,0.0,0.0);

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    //glFrustum( -1.0, 1.0,  -1.0, 1.0,  1.0, 10.0 );
    gluPerspective(70,(GLfloat)w/(GLfloat)h,1,10); 
    glTranslatef( 0.0, 0.0, -3.6 );  

    glMatrixMode( GL_MODELVIEW ); 
    glLoadIdentity();
//    glCullFace( GL_BACK );
//    glEnable( GL_CULL_FACE ); 


    /* refresh */
    
    Render_Data.draw_malla();
    return 0;
}




//***************************************************************************************
