

//************************************************************************
//***** membrasim.cpp ****************************************************
//************************************************************************

//************************************************************************
//***************** Simulacion de Membranas planas. **********************
//************************************************************************
//***** By Txino. 1997 ***************************************************
//************************************************************************



#include <malloc.h>
#include <math.h>
#include <stdio.h>
#include "membrasim.h"


//***********************************************************************
//********* Metodos de la clase "cuadricula" ****************************
//***********************************************************************

cuadricula::crea(int x,int y)
{
  int size=x*y;

  if (tabla!=NULL) destruye();
  tabla=new word[size];
  // Tratar Errores.
  
  nx=x;
  ny=y;

  clear();
  
}


void cuadricula::clear()
{     
  int cx,cy,size=nx*ny;

  for(cx=0;cx<size;cx++) tabla[cx]=0;

  for (cy=1;cy<ny-1;cy++)
   for (cx=1;cx<nx-1;cx++) tabla[cy*nx+cx]=1;
    
}

word cuadricula::get_elem(int x,int y) 
{ 
  if (x>=nx) x=nx-1;
  if (y>=ny) y=ny-1;
  if (x<0) x=0;
  if (y<0) y=0;   
  return tabla[y*nx+x]; 
}


void cuadricula::set_elem(int x,int y,word e)
{ 
  if (x>=nx) x=nx-1;
  if (y>=ny) y=ny-1;
  if (x<0) x=0;
  if (y<0) y=0;   
  tabla[y*nx+x]=e; 
}


int cuadricula::set_order()
{
  int res=0,cont,size=nx*ny;
  for (cont=0;cont<size;cont++) 
   {
     if (tabla[cont]!=0) 
      { 
        res++;
        tabla[cont]=res;
      }
   }
 
  return res;
        
}


void cuadricula::save(FILE *f)
{

  int size=nx*ny*sizeof(word);

  putw(nx,f);
  putw(ny,f);

  fwrite(tabla,size,1,f);

}


void cuadricula::load(FILE *f)
{

  int x,y;
  int size;
  
  x=getw(f);
  y=getw(f);
  size=x*y*sizeof(word);
  
  crea(x,y);
  
  if (tabla==NULL) return;

  fread(tabla,size,1,f);

}

 
    
//***********************************************************************
//*************** Metodos de la clase "vector" **************************
//***********************************************************************  


vector::vector(int n,float v)
{
   N=0;
   dat=new float[n];
   // Tratar Errores.
   
   N=n;
   operator=(v);
}   
   
  
vector & vector::operator += (vector &v)
{
   int cont;
   for (cont=0;cont<N;cont++) dat[cont]+=v.dat[cont];      
   return (*this);
}

  
vector & vector::operator -= (vector &v)
{
   int cont;
   for (cont=0;cont<N;cont++) dat[cont]-=v.dat[cont];      
   return (*this);
}
  
vector & vector::operator *= (float k)
{
   int cont;
   for (cont=0;cont<N;cont++) dat[cont]*=k;      
   return (*this);
}
  
vector & vector::operator *= (matriz_sparse &m)
{
   int cont;
   vector v(N,0);
   for (cont=0;cont<N;cont++) 
    {             
      v.dat[cont]+=m.f[cont].elem[0]*dat[m.f[cont].pos[0]];      
      v.dat[cont]+=m.f[cont].elem[1]*dat[m.f[cont].pos[1]];      
      v.dat[cont]+=m.f[cont].elem[2]*dat[m.f[cont].pos[2]];      
      v.dat[cont]+=m.f[cont].elem[3]*dat[m.f[cont].pos[3]];      
      v.dat[cont]+=m.DP[cont]*dat[cont];      
    }
   for (cont=0;cont<N;cont++) dat[cont]=v.dat[cont];
   
   return (*this);      
}
  
vector & vector::operator = (vector &v)
{
   int cont;
   for (cont=0;cont<N;cont++) dat[cont]=v.dat[cont];      
   return (*this);
}


vector & vector::operator = (float v)
{
  int cont;
  for (cont=0;cont<N;cont++) dat[cont]=v;
}


float vector::media()
{
 int cont;
 float res=0;
 for (cont=0;cont<N;cont++) res+=dat[cont];
 res/=N;
 return res;
}


//***********************************************************************
//**************** Metodos de la clase "fila_sparse" ********************
//***********************************************************************


fila_sparse::fila_sparse(float v)
{
  int cont=0;
  for (cont=0;cont<4;cont++)
   {
     elem[cont]=v; 
     pos[cont]=0;
   }
}       


//***********************************************************************
//**************** Metodos de la clase "matriz_sparse" ******************
//***********************************************************************

matriz_sparse::matriz_sparse(int n,float v)
{
  DP=new float[n];
  // Tratar Errores.
  f=new fila_sparse[n](0);
  // Tratar Errores.
  
  N=n;
  int cont;
  for (cont=0;cont<N;cont++) DP[cont]=v; 

}


matriz_sparse & matriz_sparse::operator *= (vector &v)
{
   int cont;
   for (cont=0;cont<N;cont++) 
    {     
      DP[cont]*=v.dat[cont];
      f[cont].elem[0]*=v.dat[cont];
      f[cont].elem[1]*=v.dat[cont];
      f[cont].elem[2]*=v.dat[cont];
      f[cont].elem[3]*=v.dat[cont]; 
    }        
   return (*this);   
}


matriz_sparse & matriz_sparse::operator += (float k)
{
   int cont;
   for (cont=0;cont<N;cont++) DP[cont]+=k;
   return (*this);   
}


matriz_sparse & matriz_sparse::operator = (matriz_sparse &m)
{
   int cont,i;
   for (cont=0;cont<N;cont++) 
    {   
      DP[cont]+=m.DP[cont];
      for (i=0;i<4;i++)
       {      
         f[cont].elem[i]=m.f[cont].elem[i];
         f[cont].pos[i]=m.f[cont].pos[i];
       }  
    }        
   return (*this);   
}
    
  
int matriz_sparse::GaussSeidel(vector &B,vector &X,float MAX_ITE,float TOL)
{
  float a,acum,error;
  int i,ite=0;
  
  do {
       acum=error=0;
       ite++;
       
       for (i=0;i<N;i++)
        {       
         a=B[i];
         a-=f[i].elem[0]*X[f[i].pos[0]];
         a-=f[i].elem[1]*X[f[i].pos[1]];
         a-=f[i].elem[2]*X[f[i].pos[2]];
         a-=f[i].elem[3]*X[f[i].pos[3]];
         a/=DP[i];
         error+=fabs(a-X[i]);
         acum+=fabs(a);  
         X[i]=a;         
        }
     } while ((error/acum>TOL)&&(ite<MAX_ITE));
     
  if (ite<MAX_ITE) return ite;
  else return -1;
}



//***********************************************************************
//********* Metodos de la clase "ecu_onda" ******************************
//***********************************************************************


ecu_onda::ecu_onda(int n)
{
  N=0;
  set_param(0,1,1,0.1,0.001); 
  set_toles(10,0.0001,0.01);
  set_metodo(IMPLICITO);

  crea(n); 
}


ecu_onda::~ecu_onda()
{ 
  destruye();  
}



void ecu_onda::crea(int n)
{ 
  if (N!=0) destruye(); 
  if (n==0) return;
  U=new(vector[2])(n,0);
  B=new(vector)(n,0);
  T=new(vector)(n,tension);
  matM=new(matriz_sparse)(n,-4);

  N=n;
  d_U=0;
}


void ecu_onda::destruye()
{ 

  if (N==0) return;
  delete U;
  delete B;
  delete T;
  delete matM;
  N=0;
}


void ecu_onda::set_tension(float a)
{
  tension=a;
  if (N!=0) calcula_T(a);
}


void ecu_onda::set_param(float m,float tens,float r,float h0, float k0)
{
  mu=m;
  tension=tens;
  ro=r;
  h=h0;
  k=k0;

  calcula_constants();
}


void ecu_onda::calcula_constants()
{ 
  landa=ro*h*h;
  alfa=mu*landa/k;       // alfa=(ro*h*h*mu)/k
  landa*=2/(k*k);        // landa=(2*ro*h*h)/(k*k)
}



void ecu_onda::calcula_T(float v)
{
  (*T)=v;
}




//***** Las 3 funciones que siguen, son el corazon de la simulacion: 


void ecu_onda::calcula_M(cuadricula &cua)
{
  int cx,cy,cont=0,e;
  float s=1;           

  for (cy=0;cy<cua.ny;cy++)
   for (cx=0;cx<cua.nx;cx++)
    {
      if (cua.get_elem(cx,cy)!=0)
       {        
         e=cua.get_elem(cx,cy-1);        
         if (e!=0) 
          {
           matM->f[cont].elem[0]=s;
           matM->f[cont].pos[0]=e-1; 
          }

         e=cua.get_elem(cx-1,cy); 
         if (e!=0) 
          {
           matM->f[cont].elem[1]=s;
           matM->f[cont].pos[1]=e-1; 
          }      
         
         e=cua.get_elem(cx+1,cy); 
         if (e!=0) 
          {
           matM->f[cont].elem[2]=s;
           matM->f[cont].pos[2]=e-1; 
          }

         e=cua.get_elem(cx,cy+1); 
         if (e!=0) 
          {
           matM->f[cont].elem[3]=s;
           matM->f[cont].pos[3]=e-1; 
          }

         matM->DP[cont]=-4*s;
         cont++;
         if (cont>N) return;      // Fallo. 
       }
    }        
  (*matM)*=(*T);             
}


//********************************
// Esquema explicito ***********


int ecu_onda::itera_U_exp()
{
  (*matM)+=(alfa);              

  (*B)=U[1];                      // Salvar U[1];

  U[1]*=2/(alfa+landa);
  U[1]*=(*matM);
  U[0]*=(alfa-landa)/(alfa+landa);
  U[1]-=U[0]; 

  U[0]=(*B);
  (*matM)+=(-alfa);
  return 0;
}



//********************************
// Esquema alternativo ***********


void ecu_onda::prepara_sistema()
{
  (*matM)+=(alfa-landa);           // Calcula Vector terminos independientes.

  (*B)=U[1];
  (*B)*=(-2*landa);
  U[0]*=(*matM);
  (*B)-=U[0]; 

  U[0]=U[1];

  (*matM)+=-2*alfa;                // Calcula matriz del sistema.
}


//********************************
// Esquema original **************
/*
void ecu_onda::prepara_sistema()
{
  (*matM)+=(2*landa);          

  (*B)=U[0];
  (*B)*=(landa-alfa);
  U[0]=U[1]; 
  U[0]*=(*matM);
  (*B)-=U[0]; 

  U[0]=U[1];

  (*matM)+=-(alfa+3*landa);                
}
*/



int ecu_onda::itera_U_imp()   // Devuelve -1 si se sobrepasa el max de iteraciones.
{
  int res;
  prepara_sistema();
  res=matM->GaussSeidel(*B,U[1],GS_MAX,GS_TOL);
  (*matM)+=(landa+alfa);
  return res;
}



int ecu_onda::itera_U()
{
  if (metodo==EXPLICITO) return itera_U_exp();
  else return itera_U_imp();
}




//****************************************


void ecu_onda::save(FILE *f)
{

  fwrite(this,40,1,f); 

}


void ecu_onda::load(FILE *f)
{

  fread(this,40,1,f);

}



//***********************************************************************     
//***********************************************************************
//***********************************************************************
