/*

 splash Version 0.1 (initial release) 1999/04/14 Peter Hartshorn

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to 

	the Free Software Foundation, Inc., 
	675 Mass Ave, 
	Cambridge, 
	MA 02139, USA.

*/

#include <vga.h>
#include <vgagl.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/utsname.h>
#include <string.h>
#include <utmp.h>


void handleSIG(int i)
{
	const char *lockfile = "/tmp/splash.lock";

	remove(lockfile);
	exit(0);
}

void checkProcess()
{
	FILE *fd;
	char *lockfile = "/tmp/splash.lock";
	int pid;

	fd = fopen(lockfile, "r");
	if (fd == NULL) {
		fd = fopen(lockfile, "w");
		pid = getpid();
		fprintf(fd, "%d\n",&pid);
		fclose(fd);
	}
	else {
		fclose(fd);
		exit(0);
	}
}

void drawScrollingBar()
{
	int i;
	for (i=0; i<4; i++) {
		gl_setpalettecolor(248+i,0,0,i*8+39);
		gl_setpalettecolor(252+i,0,0,55-i*8);
	}

	for (i=0;i<8;i++) {
		gl_fillbox(i*16,195,16,5,i+248);
		gl_fillbox(128+i*16,195,16,5,i+248);
		if (i<4)
			gl_fillbox(256+i*16,195,16,5,i+248);
	}
}

void setpalette(int fd)
{
	unsigned char *rgb;
	unsigned char *data;
	int i;

	rgb = alloca(3);
	data = alloca(4);
	for (i=0; i<256; i++) {
		read(fd, data, 4);
		rgb[0] = (char)((int)data[2] /4);
		rgb[1] = (char)((int)data[1] /4);
		rgb[2] = (char)((int)data[0] /4);
		gl_setpalettecolors(i,1,rgb);
	}
}

void readimage(void *image)
{
	int fd;
	char header[55];
	char *filename = "/etc/splash.bmp";

	fd = open(filename, O_RDONLY);
	read(fd, header, 54);
	setpalette(fd);
	read(fd, image, 64000);
	close(fd);
}

int getrunlevel()
{
	FILE *fp;
	struct utmp ut;
	char *file = UTMP_FILE;
	
	if((fp = fopen(file, "r")) != NULL) {
		while (fread(&ut,sizeof(struct utmp), 1, fp) == 1) {
			if (ut.ut_type == RUN_LVL) {
				fclose(fp);
				return ut.ut_pid % 256;
			}
		}
	}
	return -1;
}

unsigned int getWhiteColor()
{
	unsigned int i;
	unsigned int white=255;
	unsigned int r,g,b;

	for (i=0; i<255; i++) {
		gl_getpalettecolor(i,&r,&g,&b);
		if ((r > 60) && (g > 60) && (b > 60))
			white = i;
	}
	return white;
}

void displaysysteminfo()
{
	struct utsname buf;
	void *fp;
	char *info;

	uname(&buf);
	info = alloca(256);
	gl_setwritemode(FONT_COMPRESSED | WRITEMODE_MASKED);
	gl_setfontcolors(0,getWhiteColor());
	gl_setfont(8,8,gl_font8x8);
	info[0] = '\0';
	strncat(info,"Kernel ",255);
	strncat(info,buf.release,255);
	gl_write(30,100,info);
	info[0] = '\0';
	strncat(info,"Machine ",255);
	strncat(info,buf.machine,255);
	gl_write(30,108,info);

	switch (getrunlevel()) {
		case '0': info = "Halting system";break;
		case '1': info = "Single user mode";break;
		case '2': info = "Multi user mode";break;
		case '3': info = "Multi user mode";break;
		case '5': info = "X11 user mode"; break;
		case '6': info = "Rebooting"; break;
	}
	gl_write(30,124,info);
}	

void loopme(int scroll)
{
	int i;
	unsigned char *rgb;
	unsigned char *palette;

	rgb = alloca(3);
	palette = alloca(3*7);

	if (scroll)
		drawScrollingBar();
	while (1) {
		if (scroll) {
			gl_getpalettecolors(248,1, rgb);
			gl_getpalettecolors(249,7, palette);
			gl_setpalettecolors(248,7, palette);
			gl_setpalettecolors(255,1, rgb);
			sleep(1);
		}
	}
}

void setsignals()
{
	signal(SIGHUP, handleSIG);
	signal(SIGINT, handleSIG);
	signal(SIGTERM, handleSIG);
}

main(int argc, char **argv)
{
	void *image;
	int c=0;
	int showinfo=0;
	int scrollbar=0;

	checkProcess();
	while (!(c == -1)) {
		c = getopt(argc, argv, "il");
		switch (c) {
			case 'i' : showinfo = 1; break;
			case 'l' : scrollbar = 1; break;
		}
	}

	vga_init();
	vga_setmode(G320x200x256);
	gl_setcontextvga(G320x200x256);
	gl_setrgbpalette();
	image = alloca(320*200);

	readimage(image);
	gl_putbox(0,0,320,200,image);
	if (showinfo)
		displaysysteminfo();
	setsignals();
	loopme(scrollbar);
}
