/* $Id: xstrdup.c,v 1.3 1998/07/05 17:16:00 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            xstrdup.c
 *  MODULE OF       xalloc - memory allocation with error checking
 *
 *  DESCRIPTION     strdup-matching routine. Aborts program or calls a
 *                  user supplied function if no more memory left.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "xalloc.h"

extern void _xaOutOfMem(void);

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          xstrdup
 *
 *  FUNCTION      Do as strdup(3), but with error handling.
 *
 *  SYNOPSIS      #include "xalloc.h"
 *                char *xstrdup(size_t size);
 *
 *  INPUT         size    number of bytes to allocate.
 *
 *  RETURNS       Pointer to buffer allocated. Never returns in case
 *                of error.
 */
char *
xstrdup(const char *s)
{
    char *ret;

    if ((ret = strdup(s)) == NULL)
	_xaOutOfMem();
    return ret;
}
