/* $Id: xrealloc.c,v 1.3 1998/07/05 17:16:00 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            xrealloc.c
 *  MODULE OF       xalloc - memory allocation with error checking
 *
 *  DESCRIPTION     realloc-matching routine. Aborts program or calls a
 *                  user supplied function if no more memory left.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdlib.h>

#include "xalloc.h"

extern void _xaOutOfMem(void);

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          xrealloc
 *
 *  FUNCTION      Do as realloc(3), but with error handling.
 *
 *  SYNOPSIS      #include "xalloc.h"
 *                void *xrealloc(void *ptr, size_t size);
 *
 *  INPUT         ptr     pointer to buffer to resize.
 *                size    new number of bytes for the buffer.
 *
 *  RETURNS       Possibly new pointer to the buffer. Never returns in case
 *                of error.
 *
 *  NOTES         This function can be used for first time allocations too,
 *                just let ptr be NULL. Many implementations of realloc(3)
 *                also handles this, but not all.
 */
void *
xrealloc(void *ptr, size_t size)
{
    void *ret;

    /* some versions of realloc don't handle initial allocations if
     * ptr==NULL, so we better help those old ones. */
    if (ptr == NULL)
	ret = malloc(size);
    else
	ret = realloc(ptr, size);
    if (ret == NULL)
	_xaOutOfMem();
    return ret;
}
