/* $Id: xmalloc.c,v 1.3 1998/07/05 17:16:00 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            xmalloc.c
 *  MODULE OF       xalloc - memory allocation with error checking
 *
 *  DESCRIPTION     malloc-matching routine. Aborts program or calls a
 *                  user supplied function if no more memory left.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdlib.h>

#include "xalloc.h"

extern void _xaOutOfMem(void);

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          xmalloc
 *
 *  FUNCTION      Do as malloc(3), but with error handling.
 *
 *  SYNOPSIS      #include "xalloc.h"
 *                void *xmalloc(size_t size);
 *
 *  INPUT         size    number of bytes to allocate.
 *
 *  RETURNS       Pointer to buffer allocated. Never returns in case
 *                of error.
 */
void *
xmalloc(size_t size)
{
    void *ret;

    if ((ret = malloc(size)) == NULL)
	_xaOutOfMem();
    return ret;
}
