/* $Id: xcalloc.c,v 1.3 1998/07/05 17:16:00 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            xcalloc.c
 *  MODULE OF       xalloc - memory allocation with error checking
 *
 *  DESCRIPTION     calloc-matching routine. Aborts program or calls a
 *                  user supplied function if no more memory left.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdlib.h>

#include "xalloc.h"

extern void _xaOutOfMem(void);

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          xcalloc
 *
 *  FUNCTION      Do as xcalloc(3), but with error handling.
 *
 *  SYNOPSIS      #include "xalloc.h"
 *                void *xcalloc(size_t nmemb, size_t size);
 *
 *  INPUT         nmemb   number of elements to allocate.
 *                size    number of bytes to allocate for each element.
 *
 *  RETURNS       Pointer to buffer allocated. The memory is set to zero.
 *                Never returns in case of error.
 */
void *
xcalloc(size_t nmemb, size_t size)
{
    void *ret;

    if ((ret = calloc(nmemb, size)) == NULL)
	_xaOutOfMem();
    return ret;
}
