/* $Id: xalloc.c,v 1.5 1998/07/05 17:16:00 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            xalloc.c
 *  MODULE OF       xalloc - memory allocation with error checking
 *
 *  DESCRIPTION     Functions common to the entire library.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include "xalloc.h"

/**************************************************************************
 *                                                                        *
 *                   P R I V A T E    F U N C T I O N S                   *
 *                                                                        *
 **************************************************************************/

/* Pointer to the error handler function. If the value is NULL, the
 * default action is taken (program abortion). */
static void (*xaErrFunc)(void);



/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          _xaOutOfMen
 *
 *  FUNCTION      Handle out of memory -problems.
 *
 *  DESCRIPTION   This is the function that is called when any of the
 *                memory functions fail. If the user has set up a handler
 *                function, this function is called. Else the program
 *                is aborted with an "out of memory"-message on stdout.
 *
 *  NOTE          This is considered an internal function. It should not
 *                be called by the user.
 */
void
_xaOutOfMem(void)
{
    if (!xaErrFunc)
	fprintf(stderr, "out of memory\n");
    else
	xaErrFunc();
    exit(99);
}



/*-------------------------------------------------------------------------
 *
 *  NAME          xaSetErrFunc
 *
 *  FUNCTION      Specify a user supplied error handling function.
 *
 *  SYNOPSIS      #include "xalloc.h"
 *                void xaSetErrFunc(void (*f)(void));
 *
 *  INPUT         f       pointer to function that should be called when
 *                        any of the memory (re-)allocating functions
 *                        fail. If the function supplied returns, the
 *                        program is aborted. The function may very well
 *                        use setjmp/longjmp to do some major recovery.
 *
 *                        Let f be NULL to restore the default action,
 *                        which is to display "out of memory" and abort
 *                        the program.
 */
void
xaSetErrFunc(void (*f)(void))
{
    xaErrFunc = f;
}
