/*
 * sem.h --
 *
 *      Header file for the semaphore services.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#ifndef _SEM_H
#define _SEM_H

#include <pthread.h>
#include "symtab.h"
#include "os_mtosux.h"

typedef struct sem_tab_t {
    sym_t           symtype;    
    pthread_mutex_t sem_mutex;
    pthread_cond_t  sem_timer;
    int             count;
} OS_SEM_TYPE;

#endif
