/*
 * os_timer.h --
 *
 *      Header file for timer support functions.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */

#ifndef _OS_TIMER_H
#define _OS_TIMER_H

/* Macros to convert between timevals and timespecs */

#define TIMEVAL_TO_TIMESPEC(tv, ts) {               \
        (ts)->tv_sec = (tv)->tv_sec;                \
        (ts)->tv_nsec = (tv)->tv_usec * 1000;       \
}
#define TIMESPEC_TO_TIMEVAL(tv, ts) {               \
        (tv)->tv_sec = (ts)->tv_sec;                \
        (tv)->tv_usec = (ts)->tv_nsec / 1000;       \
}

#endif
