/*
 * msb.h --
 *
 *      Header file for  message buffer services.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#ifndef _MSBS_H
#define _MSBS_H

#include <pthread.h>
#include "symtab.h"
#include "os_mtosux.h"

#define MAX_QUEUE_SIZE    MAX_SIZE
#define MAX_MSBS          100
#define MSB_NORMAL        0
#define MSB_DELETED       1

typedef struct msb_tab_t {
    sym_t          symtype;    
    pthread_cond_t msg_cond;
    UPTR*          msg_buf;
    int            max_queue_sz;
    int            queue_len;
    int            status;
} OS_MSB_TYPE;

uxid_t add_msb(key_t key, int sz);
long   send_msg(uxid_t msbid, UPTR msg, int at_end);
long   delete_msb(uxid_t msbid);

#endif
