/*
 * mem.c --
 *
 *      Header file for memory management services.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#ifndef _MEM_H
#define _MEM_H

#include "mtosux.h"

typedef struct mem_blks_t {
    UPTR               addr;
    struct mem_blks_t* next;    
} mem_blks;

typedef struct cmp_tab_t {
    UPTR        basadr;
    ULONG       num_blks;
    ULONG       num_avail;
    ULONG       blk_len;
    mem_blks*   free_blks;    
} OS_MEM_TYPE;

#define CMP_NOT_IN_USE      0xFF

#endif
