/*
 * init.h --
 *
 *      Performs system wide initialisations.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#include <pthread.h>
#include "symtab.h"
#include "mtosux.h"

extern void inient(void);

void set_input_mode (void);
void init_timers(void);



int main (int argc, char **argv)
{
    uxid_t           initid;
    long             stabuf;
    
    const struct tcd initcd = {
        KEY('.','I','N','I'),		/* key */
        ABS+DUR+APP,	/* attributes */
        -1,		/* local/global task specifier */
        C,		/* language code */
        255,		/* inherent priority */
        0,		/* coprocessor use flags */
        (tep_t)inient,	/* entry point */
        0x300,		/* length of stack */
        0,		/* len of uninit data, if abs */
        NULL,		/* addr of initialized data, if abs */        
        0,		/* auto priority change: time interval */
        0,		/*                       increment */
        0,		/*                       limit */
        NULL		/* ptr to name of pgm file, if rel */
    };
    
    pthread_init();
    set_input_mode ();    
    init_symtab();
    init_timers();

    /*
    ** Start inient task
    */    
    initid = crtsk((struct tcd *)&initcd);	/* create first task */
    start(initid,0L,NULL,&stabuf,WAIFIN+CTERM);	/* start task */
    
    pthread_exit(NULL);
    
    return 0;
}


/*
** Simulates the console drivers
*/

struct termios saved_attributes;

void
reset_input_mode (void)
{
  tcsetattr (STDIN_FILENO, TCSANOW, &saved_attributes);
}

void
set_input_mode (void)
{
  struct termios tattr;

  /* Make sure stdin is a terminal. */
  if (!isatty (STDIN_FILENO))
    {
      fprintf (stderr, "Not a terminal.\n");
      exit (EXIT_FAILURE);
    }

  /* Save the terminal attributes so we can restore them later. */
  tcgetattr (STDIN_FILENO, &saved_attributes);
  atexit (reset_input_mode);

  /* Set the funny terminal modes. */
  tcgetattr (STDIN_FILENO, &tattr);
  tattr.c_lflag &= ~(ICANON|ECHO); /* Clear ICANON and ECHO. */
  tattr.c_cc[VMIN] = 1;
  tattr.c_cc[VTIME] = 0;
  tcsetattr (STDIN_FILENO, TCSAFLUSH, &tattr);
}
