/*
 * efg.h --
 *
 *      Header file for event flag services.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#ifndef _EFG_H
#define _EFG_H

#include <pthread.h>
#include "mtosux.h"
#include "syscfg.h"
#include "symtab.h"

/* Event flag parameters                 */
#define EFG_DELETED      0
#define EFG_NORMAL       1
#define EFG_ACTIVE       2

#define OP(opmask)      (opmask >> 16)
#define MASK(opmask)    ((short)opmask)

typedef struct {
    pthread_cond_t  efg_set; 
    pthread_mutex_t efg_mutex;    
} OS_COND_TYPE;

typedef struct efg_t {
    sym_t          symtype;    
    uxid_t	   gid;	/* event flag id */
    key_t          key;	/* event flag key */
    unsigned short flags;
    unsigned short xflags;
    unsigned short status;        
    OS_COND_TYPE   os_efg;
} OS_EVT_FLAG_TYPE;

/*
 * Structure access macros
 */
#define GET_OS_COND(efType)        efType.os_efg.efg_set
#define GET_OS_MUTEX(efType)       efType.os_efg.efg_mutex

/*
 * Function prototypes
 */
extern long os_init_efg(OS_EVT_FLAG_TYPE* efg);

#endif
